package NextCAM::Servicing::Client;
use strict;
use warnings;

use lib "/opt/sarch/imp/lib/perl"; # thrift api

use Thrift::BinaryProtocol;
use NextCAM::Messenger;
use NextCAM::Servicing::MBusTransport;

sub new
{

  my $class = shift;
  my $host = shift;
  my $port = shift;
  my $helo = shift || "$0 (NextCAM::Servicing::Client-perl)";

  my $messenger = NextCAM::Messenger->new(
                                          host	       	=> $host,
                                          port		=> $port,
                                          conn_timeout	=> 1000,
                                          helo          => $helo
                                         );

  #die "Failed to connect!\n" unless defined $messenger;

  my $self = {
              messenger	=> $messenger
             };

  return defined $messenger ? bless($self, $class) : undef;
}

sub getProtocol
{
  my $self = shift;
  my $servicename = shift;
  my $recv_timeout = shift || 0xffffffff;
  my $transport = NextCAM::Servicing::MBusTransport->new($self->{messenger}, $servicename, $recv_timeout);

  $transport->open();
  my $proto =  Thrift::BinaryProtocol->new($transport);
  return $proto;
}
1;
