package NextCAM::PTZ;

use 5.008008;
use strict;
use warnings;

use HTTP::Request;
use Math::Trig;
use SKM::Agent;

require Exporter;

our @ISA = qw(Exporter);

our %EXPORT_TAGS = ( 'all' => [ qw( checkURL httpAuth httpHeaders hfov2step ) ] );

our @EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );

our @EXPORT = qw( checkURL httpAuth httpHeaders hfov2step );

our $VERSION = '0.01';

my $ua = SKM::Agent->new;
my $defTimeout = 2;
my ($usrname, $passwd);
my $defHttpHeaders = {
    "Accept" => "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png",
    "Accept-Charset" => "iso-8859-1,*,utf-8",
    "Accept-Encoding" => "gzip",
    "Accept-Language" => "en",
    "User-Agent" => "Mozilla/4.76 [en] (X11; U; Linux 2.2.16 i686)"
};

sub httpHeaders {
    my $hdrs = shift;
    return unless ref $hdrs eq 'HASH';
    $defHttpHeaders = $hdrs;
}

sub httpAuth {
    ($usrname, $passwd) = @_ if @_;
}

# Submit HTTP GET request
sub checkURL {
    my ($url, $timeout, $skip_def_hdr, $hdrs) = @_;
    $timeout = $defTimeout unless defined $timeout;

    my $request = HTTP::Request->new(GET => $url);
    $ua->set_creds($usrname, $passwd);

    if (!$skip_def_hdr) {
	$request->header("Accept", "image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png");
        $request->header("Accept-Charset", "iso-8859-1,*,utf-8");
        $request->header("Accept-Encoding", "gzip");
        $request->header("Accept-Language", "en");
        $request->header("User-Agent", "Mozilla/4.76 [en] (X11; U; Linux 2.2.16 i686)");
    }

    if ($hdrs and ref $hdrs) {
	if (ref $hdrs eq 'HASH')   { $request->header($_, $hdrs->{$_})  foreach keys %$hdrs; }
	if (ref $hdrs eq 'ARRAY')  { $request->header($_->[0], $_->[1]) foreach @$hdrs;      }
    }

    $ua->timeout($timeout);
    my $resp = $ua->request($request);
    return $resp->is_error() ? "HTTP ERROR [".$resp->code."]" : $resp->content();
}

# return step (0..1)
sub hfov2step {
	my($conf, $hfov, $isZoom) = @_;

	my $text = $$conf->{PTZ_HFOV_MIN};
	if ($hfov < $$conf->{PTZ_HFOV_MIN})
	{
		$hfov = $$conf->{PTZ_HFOV_MIN};
	}
	elsif ($hfov > $$conf->{PTZ_HFOV_MAX})
	{
		$hfov = $$conf->{PTZ_HFOV_MAX};
	}

	my $step;

	if ($$conf->{PTZ_FOCAL_LENGTH_MIN} eq '' || $$conf->{PTZ_FOCAL_LENGTH_MAX} eq '')
	{
		$step = 1 - ($hfov - $$conf->{PTZ_HFOV_MIN}) / ($$conf->{PTZ_HFOV_MAX} - $$conf->{PTZ_HFOV_MIN});
	} else {
		if ($isZoom)
		{
			my $zoom = tan(deg2rad($$conf->{PTZ_HFOV_MAX}/2)) / tan(deg2rad($hfov/2));

			# check $zoom for Round-off error
			if ($zoom < 1)
			{
				$zoom = 1;
			}
			elsif ($zoom > $$conf->{PTZ_ZOOM_OPTICAL_MAX})
			{
				$zoom = $$conf->{PTZ_ZOOM_OPTICAL_MAX};
			}

			$step = $zoom / $$conf->{PTZ_ZOOM_DIGITAL_MAX};
		} else {
			# use linear interpolation
			my $x0 = deg2rad($$conf->{PTZ_HFOV_MIN} / 2);
			my $x1 = deg2rad($$conf->{PTZ_HFOV_MAX} / 2);
			my $fx0 = $$conf->{PTZ_FOCAL_LENGTH_MAX} * tan($x0) / tan(deg2rad($hfov / 2));
			my $fx1 = $$conf->{PTZ_FOCAL_LENGTH_MIN} * tan($x1) / tan(deg2rad($hfov / 2));
			my $focalLength = $fx0 * ($x1 - deg2rad($hfov)) / ($x1 - $x0) + $fx1 * (deg2rad($hfov) - $x0) / ($x1 - $x0);

			# check $focalLength for Round-off error
			if ($focalLength > $$conf->{PTZ_FOCAL_LENGTH_MAX})
			{
				$focalLength = $$conf->{PTZ_FOCAL_LENGTH_MAX};
			}
			elsif ($focalLength < $$conf->{PTZ_FOCAL_LENGTH_MIN})
			{
				$focalLength = $$conf->{PTZ_FOCAL_LENGTH_MIN};
			}

			$step = ($focalLength - $$conf->{PTZ_FOCAL_LENGTH_MIN}) / ($$conf->{PTZ_FOCAL_LENGTH_MAX} - $$conf->{PTZ_FOCAL_LENGTH_MIN});
		}
	}

	return $step;
}

1;
__END__
