#  $Id: OMClient.pm 12484 2008-10-28 15:52:07Z starostin $
# -----------------------------------------------------------------------------
#  OM client
# -----------------------------------------------------------------------------
#  Author: Yaroslav Sinyatkin  (yas@videonext.net)
#  Edited by: Alexey Tsibulnik
#  QA by:  
#  Copyright: (c) videoNEXT LLC, 2005
# -----------------------------------------------------------------------------
# ------------------------------------------------------------------------------

use strict;
use warnings;

use lib "/opt/sarch/common/lib"; # service API
use lib "/opt/sarch/om/bin/perl/OMIface";
use lib "/opt/sarch/imp/lib/perl"; # thrift api

package OMClient;

use ObjectManagementService;
use NextCAM::Servicing::Client;

sub new
{
  	my $class = shift;
  	my $helo  = shift || "$0 NextCAM::OMClient-perl";

	my $service_client = NextCAM::Servicing::Client->new("s_master", 10000, $helo);
	return undef unless $service_client;
	my $om_client = ObjectManagementServiceClient->new($service_client->getProtocol("skm.om"));

  	my $self = {
              om_client	=> $om_client
               };

  	return defined $om_client ? bless($self, $class) : undef;
}


# calls OM->updateProperties
# returns '' or error string
sub send_update
{
	# TODO: get array of objid & states (accumulated request)
	my $self  = shift;
	my $objid = shift;
	my $props = shift;
#	my $state = shift;

	my $action = {
               #name => "update_properties",
               #parameters => {
				$objid     => $props#{ "health"    => ''.$state}
                #             }
             };

    eval
    {
      $self->{om_client}->updateProperties($action);
    };
    if ($@ && $@->UNIVERSAL::isa("OMIface::FwException"))
    {
      return "FwIface::FwException: ". $@->{errorId}.": ".$@->{what}. "\n";
    }
    elsif( $@ ) {
      return "Bad: $@\n";
    }
    else
    {
      #print("Action performed successfully: \n");
    }
	return '';
}

sub getObjects
{
	my ($self, $objid,$err_text) = @_;

	my $res = undef;
    my $obj_ref 	= {objid => $objid};
    my $obj 	= new ObjectRef($obj_ref);
    my @obj_arr	= ($obj);
    my $objlist = {objectListFilter => \@obj_arr};

	my @props = ('health');
    my $o = { includeMethods => 0,
    		  properties => \@props
    };

    eval
    {
		local $SIG{ALRM} = sub { die "die by timeout\n" }; # NB: \n required
		alarm 3;
    	$res = $self->{om_client}->getObjects(new Filter($objlist), new OutputOptions ($o));
		alarm 0;
	  	return $res;	
    };

    if ($@ && $@->UNIVERSAL::isa("OMIface::FwException"))
    {
      $err_text = "FwIface::FwException: ". $@->{errorId}.": ".$@->{what}. "\n";
    }
    elsif ($@)
    {
      $err_text = "timeout exception: ". $@. "\n";
		#print "err_text=$err_text\n";
    }
	return $res;
	
}
1;