package NextCAM::Messenger::Shared;

use Exporter;

use warnings;
use vars qw($VERSION);
$VERSION = 1.02;

@ISA = ('Exporter');

@EXPORT = qw(&_elem  &create_uid &ushort2bits 
	     &bits2ushort &compute_crc &subscmp
	     &msg_str
	    );

my @chars = ("A".."Z","a".."z","!","@","#","\$","%","^","&","*","(",")","-","+",
	    0..9);

sub _elem
{
    my $self = shift;
    my $elem = shift;
    my $old = $self->{$elem};
    $self->{$elem} = shift if @_;
    return $old;
}

sub create_uid {
    
    my $len = shift || 32;
    return join("", @chars[ map { rand @chars } ( 1..$len ) ] );
}

sub compute_crc {
    
    my ($arg1, $arg2) = @_;
    return $arg1 ^ $arg2;
}

sub ushort2bits {

    my $temp = pack("S", shift);
    return reverse( split(//, unpack('b16', $temp)) );
}

sub bits2ushort {

     my $temp = reverse( split(//, shift));
     return  unpack('S', pack('b16', $temp));    
}


sub subscmp {

    my ($sub1, $sub2) = @_;
    while( my ($key, $val) = each(%$sub1) )
    {
	if ( ($key ne 'data') && ($sub2->{$key} ne $val) )
	{
	    return 1;
	}
    }
    return 0;
}


sub msg_str {
    
    my $msg = shift;
    my $format = shift || 0;
    my $str;    

    if($format == 0)
    {
	$str  = "{\n\t" . 	       
	       "deviceIP    => " . $msg->{device_IP} . "\n\t" .
	       "deviceID    => " . $msg->{device_ID} . "\n\t" .
	       "ctxType     => " . $msg->{ctxType} . "\n\t" .
	       "evtType     => " . $msg->{evtType} . "\n\t" .
    	       "procLvl     => " . $msg->{procLvl} . "\n";
	        
	$str .= "\tuserid      => " . $msg->{userid} ."\n" 
				    if defined($msg->{userid});
	$str .= "\tmessage_ID  => " . $msg->{message_ID} ."\n" 
				    if defined($msg->{message_ID});	
        $str .= "\tdata        => " . $msg->{data} . "\n" if defined($msg->{data});
	$str .= "\tsubscriber  => " . $msg->{subscriber} . "\n" 
				    if defined($msg->{subscriber});
				    
	if(defined($msg->{att_description}) && defined($msg->{att_data}))
	{
	    my @att_description = @{$msg->{att_description}};
	    my @att_data = @{$msg->{att_data}};
	    
	    for(my $i = 0; $i <= $#att_data; ++$i)
	    {
		$str .= "\tattachment$i => [$att_description[$i], " .
			"$att_data[$i]]\n";
	    }
	}
	
        $str .=  "}";
	
	
    }
    elsif($format == 1)
    {
	$str = $msg->{device_IP} . " " . $msg->{device_ID} . " " .
	       $msg->{ctxType} . " " . $msg->{evtType} . " " . 
	       $msg->{procLvl};
	$str .= " " . $msg->{message_ID} if defined($msg->{message_ID});
	$str .= " " . $msg->{data} if defined($msg->{data});
	
	if(defined($msg->{att_description}) && defined($msg->{att_data}))
	{
	    my @att_description = @{$msg->{att_description}};
	    my @att_data = @{$msg->{att_data}};
	    
	    for(my $i = 0; $i <= $#att_data; ++$i)
	    {
		$str .= " $att_description[$i] " .
			"$att_data[$i]";
	    }
	}
	
    }

    return $str;
}


1;
