# $Id$
package NextCAM::Messenger::Flags;
use Exporter;
@ISA=('Exporter');

  # Dimension 1
    use constant Context_Class_DOMAIN           => 1;    #//< Messages with "security-domain" scope, the most wide class
    use constant Context_Class_NODE             => 2;    #//< Nodes specific no particular domain node functioning
    use constant Context_Class_SCENE            => 4;    #//< Area grouping several devices to be analyzed in one scope
    use constant Context_Class_OBJ2D            => 8;    #//< 2D-object
    use constant Context_Class_OBJ3D            => 16;    #//< 3D-object
    use constant Context_Class_DEVICE           => 32;    #//< Camera/MIC/Relay/:
    use constant Context_Class_POSITIONER       => 64;    #//< PTZ cameras-related
    use constant Context_Class_VISION           => 128;    #//< Computer Vision: tracking/recognizing/etc:

  # Dimension 2
    use constant Event_Class_CMD                => 1;    #//< Command to be executed
    use constant Event_Class_ACK                => 2;    #//< Acknowledge to command sent
    use constant Event_Class_STATUS             => 4;    #//< Status reporting: either periodic or on-demand
    use constant Event_Class_CONFIG             => 8;    #//< Configuration change notificationas
    use constant Event_Class_PROCCTL            => 32;    #//< Process control: start/stop/notifications/etc:
    use constant Event_Class_HEALTH             => 64;    #//< Process/hardware health reporting

  # Dimension 3
    use constant Data_Processing_Level_LVL0     => 1;    #//< No processing - raw data
    use constant Data_Processing_Level_LVL1     => 2;    #//< Reserved for expansion
    use constant Data_Processing_Level_LVL2     => 4;    #//< Basic processing (ex. elementary motion detection)
    use constant Data_Processing_Level_LVL3     => 8;    #//< Reserved for expansion
    use constant Data_Processing_Level_LVL4     => 16;    #//< Elementary features extracted (ex. object tracker)
    use constant Data_Processing_Level_LVL5     => 32;    #//< Reserved for expansion
    use constant Data_Processing_Level_LVL6     => 64;    #//< Elementary processing finished (ex. global position established)
    use constant Data_Processing_Level_LVL7     => 128;    #//< Reserved for expansion
    use constant Data_Processing_Level_LVL8     => 256;    #//< Classification is done
    use constant Data_Processing_Level_LVL9     => 512;    #//< Reserved for expansion
    use constant Data_Processing_Level_LVL10    => 1024;    #//< Merged into the scene
    use constant Data_Processing_Level_LVL11    => 2048;    #//< Historical data
    use constant Data_Processing_Level_LVL12    => 4096;    #//< Merged into domain model
    use constant Data_Processing_Level_LVL13    => 8192;    #//< Behavior recognizer
    use constant Data_Processing_Level_LVL14    => 16384;    #//< Reserved for expansion
    use constant Data_Processing_Level_LVL15    => 32768;    #//< Reserved for expansion

@EXPORT = qw(
	Context_Class_DOMAIN          
	Context_Class_NODE            
	Context_Class_SCENE           
	Context_Class_OBJ2D           
	Context_Class_OBJ3D           
	Context_Class_DEVICE          
	Context_Class_POSITIONER      
	Context_Class_VISION          
	Event_Class_CMD               
	Event_Class_ACK               
	Event_Class_STATUS            
	Event_Class_CONFIG            
	Event_Class_PROCCTL           
	Event_Class_HEALTH            
	Data_Processing_Level_LVL0    
	Data_Processing_Level_LVL1    
	Data_Processing_Level_LVL2    
	Data_Processing_Level_LVL3    
	Data_Processing_Level_LVL4    
	Data_Processing_Level_LVL5    
	Data_Processing_Level_LVL6    
	Data_Processing_Level_LVL7    
	Data_Processing_Level_LVL8    
	Data_Processing_Level_LVL9    
	Data_Processing_Level_LVL10   
	Data_Processing_Level_LVL11   
	Data_Processing_Level_LVL12   
	Data_Processing_Level_LVL13   
	Data_Processing_Level_LVL14   
	Data_Processing_Level_LVL15   
);
