#!/usr/bin/perl
#  $Id: Init.pm 22889 2011-06-07 15:02:13Z teetov $
# -----------------------------------------------------------------------------
#  Perl module to provide one-point for obtaining configuration data for
#  other NEXTcam engines
# -----------------------------------------------------------------------------
#  Author: Andrey Fomenko
#  Edited by: 
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------

package NextCAM::Init;

use 5.008;
use strict;
use warnings;
use SKM::DB;
use NextCAM::Conf;

require Exporter;
#use AutoLoader qw(AUTOLOAD);
#use Log::Log4perl "get_logger";

our $VERSION = '1.01';
our @ISA = qw(Exporter);

# Symbols to be exported by request
our @EXPORT_OK = qw(GetRoot GetDBHandle);

# Symbols to be exported by default
our @EXPORT = qw(GetCfgs GetAsrv UpdateCfgs);

# Export symbols in groups
#our %EXPORT_TAGS = (
#			'all' => [ qw( ) ],
#			'db'  => [ qw( ) ]
#                   );

# ================================== Constants section ===============================

my $APL=$ENV{APL};					# directory structure root
my $APL_CONF=$ENV{APL_CONF} || "$APL/var/conf";		# conf-files are here - will be depreciated!!!
my $LOG_CFG_FILENAME = "$APL/common/etc/logger.conf";	# logger settings config file
my $LOG_CFG_REFRESH_INTERVAL = 60;			# logger config refresh interval
my $IDENTITY_OBJID = 53;				# Id of 'IDENTITY' object in _objs table in DB
my $DEBUG = 0;
my $dbh;

# ======================== Preloaded methods go here. ================================
# Autoload methods go after =cut, and are processed by the autosplit program.

# Log::Log4perl::init_and_watch($LOG_CFG_FILENAME, $LOG_CFG_REFRESH_INTERVAL);

sub debug { print STDERR "DEBUG @_\n" if $DEBUG>=shift}
sub sqls1 { debug(5,"sqls1:@_\n");$dbh->selectrow_array("@_") }
sub sqldo { debug(5,"sqldo:@_\n");$dbh->do("@_"); }
sub sqlst { debug(5,"sqlst:@_\n");my $r=$dbh->selectall_arrayref("@_"); $r;}
sub sqlist{ debug(5,"sqlist:@_\n");map{@{$_}}@{$dbh->selectall_arrayref(@_)}}

sub ReconnectDB() {
   $dbh = DBMaster({PrintError => 1});
}

sub GetRoot {
    return $APL;
} # sub GetLogger


sub GetDBHandle {
    my $dbh=DBMaster({PrintError => 1}) or die("Error connecting to database: $DBI::errstr");
    $dbh->{FetchHashKeyName} = 'NAME_lc';
    return $dbh;
}

# ------------------------------------------------------------- UpdateCfgs -----
# this version of function updates hash passed by ref to avoid memory reallocation
# also, adds to hash two keys:
#  TS - timestamp when device updated last time
#  TRG - 0-if timestamp was NOT updated, 1-if timestamp was updated, -1-device was deleted
#
# Parameters:
#   1. ref to hash
#   2. optional hash with filters
#
#  On default, return all devices, but you can specify filter criteria, like:
#  UpdateCfgs( \%my_cfgs, ('CAMERAMODEL'=>'Axis','DEVIP'=>'\d+\.\d+\.\d+\.\d+') );
#
sub UpdateCfgs {
    my ($CFGS, %filter)=@_;

    my (%devs, $dev, $cfg, $ignore, $f_ts, $key);
    
    foreach $key (keys %$CFGS) {
	$CFGS->{$key}{TRG}=-1;
    };

    opendir(CFGDIR,$APL_CONF);
    while (defined($dev = readdir(CFGDIR))) {
        next if $dev=~/^\./ or not ( $f_ts=(stat("$APL_CONF/$dev/conf"))[9] ); # writetime
        next if $dev=~/^asrv/;
        if(open(CFG,"$APL_CONF/$dev/conf")) {
            $cfg=\%{{map {/(\w+)=(.*)/} grep {/^\w+=.*$/} <CFG>}};
            close(CFG);
        } else {
#            $log->error("Unable open for reading: [$APL_CONF/$dev/conf]");
        } # if(open(CFG,"$APL_CONF/$file/conf"))
        $ignore = 0;
        foreach(keys %filter) {
            $ignore = 1, last if not defined($cfg->{$_});
            $ignore = 1, last if not ( $cfg->{$_} =~ /$filter{$_}/ );
        }
        next if $ignore;
        foreach (keys %{$cfg}) { $CFGS->{$dev}{$_}=$cfg->{$_}; };
        if(!defined($CFGS->{$dev}{TS}) || $f_ts!=$CFGS->{$dev}{TS}) {
            $CFGS->{$dev}{TS} = $f_ts;
            $CFGS->{$dev}{TRG} = 1;
        }
        else {
            $CFGS->{$dev}{TRG} = 0;
        }
    } # while (defined($file = readdir(CFGDIR)))
    closedir(CFGDIR);
} # sub UpdateCfgs

# ---------------------------------------------------------------- GetAsrv -----
# Reads configuration from postgres
sub GetAsrv {
  my %asrv = ();
  my $dbm=DBMaster({PrintError=>0,RaiseError=>0});
  if ($dbm) {
    my $attr=$dbm->selectall_arrayref("select attr,val from _obj_attr where obj=$IDENTITY_OBJID");
    %asrv=map{@{$_}} @$attr if $attr;
    $dbm->disconnect;
  }
  return %asrv;
} # sub GetAsrv

1;
__END__

# ----------===== Changes log =====----------
# $Log$
# Revision 1.25  2006/10/31 17:40:04  posox
# exclude asrv.conf from UpdateCfgs
#
# Revision 1.24  2006/10/31 17:36:03  posox
# exclude asrv.conf from GetCfgs
#
# Revision 1.23  2006/08/31 19:40:00  posox
# ^ in .../conf/conf/
#
# Revision 1.22  2006/08/31 18:35:24  posox
# GetConf - fix: return correct conf for DEVices in /conf/conf/$devid.conf files
#
# Revision 1.21  2006/08/29 02:47:47  afomenko
# added "GetDBHandle" function
#
# Revision 1.20  2006/06/29 15:58:47  posox
# remove check of existense conf file in GetCfgs() - working around error on fileopen
#
# Revision 1.19  2006/06/06 06:50:36  zlata
# fixed error selection device
#
# Revision 1.18  2006/03/27 19:01:25  afomenko
# debug info deleted
#
# Revision 1.17  2006/03/27 18:55:49  afomenko
# fixed bug with default value substitute when attribute is missing in conf-file, but present in template
#
# Revision 1.16  2006/03/02 22:15:26  afomenko
# when reporting device parameters - now they are extended with default parameters from template - DEBUG made :)
#
# Revision 1.15  2006/03/02 22:02:52  afomenko
# when reporting device parameters - now they are extended with default parameters from template
#
# Revision 1.14  2006/02/27 19:50:06  afomenko
# load changed config first, then "stable" one
#
# Revision 1.13  2006/02/27 19:48:01  afomenko
# added reporting of devices not processed with patrol
#
# Revision 1.12  2004/06/10 19:26:44  afomenko
# CR/LF -> LF
#
# Revision 1.11  2004/06/10 15:55:53  afomenko
# Added header/trailer with copyright, id, log
#
