#  $Id: ELogClient.pm 12484 2008-10-28 15:52:07Z starostin $
# -----------------------------------------------------------------------------
#  EventLog client
# -----------------------------------------------------------------------------
#  Author: Alexey Tsibulnik
#  Edited by: Alexey Tsibulnik
#  QA by:  
#  Copyright: (c) videoNEXT LLC, 2005
# -----------------------------------------------------------------------------
# ------------------------------------------------------------------------------

package ELClient;

use strict;
use warnings;

use lib "/opt/sarch/common/lib";
use lib "/opt/sarch/fw/bin/perl/FwIface";
use lib "/opt/sarch/fw/bin/perl";
use lib "/opt/sarch/elog/bin/perl";
use lib "/opt/sarch/elog/bin/perl/ELogIface";

use NextCAM::Servicing::Client;
use FwIface::Types;
use ELog;

sub new
{
	my $class = shift;
	my $helo  = shift || "$0 NextCAM::ELogClient-perl";

	my $params = {
		helo    => $helo,
		error   => ''
	};
	
	my $self = bless($params, $class);
	return undef unless $self->init;
	return $self;
}

sub init
{
	my $self = shift;
	
	undef $self->{client};
	my $service_client = NextCAM::Servicing::Client->new("s_master", 10000, $self->{helo});
	return undef unless $service_client;
	
	$self->{client} = ELogClient->new($service_client->getProtocol("skm.eventlog"));
	return $self->{client};
}

sub createEvent
{
	my $self = shift;
	my $params = shift;
	my $async = shift;
	
	my $resp = $self->submitAction("create", $params);
	$resp = $resp->{parameters}{eventid} if $resp and not $async;
	
	return $resp;
}

sub updateEvent
{
	my $self = shift;
	my $params = shift;
	my $async = shift;
	
	my $resp = $self->submitAction("update", $params);
	return UNIVERSAL::isa($resp, "ActionResponse") ? 1 : undef;
}

sub submitAction
{
	my $self    = shift;
	my $actname = shift;
	my $params  = shift;
	my $async   = shift;
	
	my $action = Action->new({
    		name => $actname,
        	parameters => $params
        });

	my $resp;
	my $tries = 2;
	$self->{error} = "";
	while ($tries--) {
		eval {
			$resp = $async ? 
				$self->{client}->submitActionA($action) : 
				$self->{client}->submitAction($action);
		};
		if ($@) {
			if (UNIVERSAL::isa($@, "FwException")) {
				$self->{error} = "FwException: ". $@->{errorId}.": ".$@->{what};
				last;
			}
			elsif (UNIVERSAL::isa($@, 'Thrift::TException')) {
				$self->{error} = "Thrift::TException";
				last unless $self->init;
				next;
			}
			else {
				$self->{error} = "Unknown error: $@";
				last;
			}
		}
		else {
		    last;
		}
	}
    
	return $resp;
}

1;