#!/usr/bin/perl -w
#  $Id: cam_alarm.pl 7045 2007-01-11 06:37:10Z teetov $
# -----------------------------------------------------------------------------
#  Add record into camera motion log [ LEGACY VERSION ]
#  [ TBD: IP access check : localhost or IP camera ] 
#  
#  Calling syntax: 
#     http://<ip>/sarch/cgi-bin/cam/cam_alarm.pl?dev=<ID>&message=<message>
#     http://<ip>/sarch/cgi-bin/cam/cam_alarm.pl?objid=<objID>&message=<message>
#	
#  This is LEGACY version, please do not use it for any new development
#  Please use:
#    http://s_master/api/cgi-bin/eventlog.cgi?modify=append&utc_event=NOW&objid=<objid>&message=<message>
# -----------------------------------------------------------------------------
#  Author: Andriy Fomenko
#  Cut short: Alex Titov
#  Edited by: 
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------
#  parameters:
#       dev || devid || objid   - one and only one of this parameters has to be present 
#  optional parameters:
#       message=
#       mark=yes
#       interval=[config|b:a] (Example : &interval=5:20 - mark 5 seconds before the event and 20 seconds after)
#  follow parameters are de-supported:
#       directfrom=yy-mm-dd_hh-mm-ss
#       directto=yy-mm-dd_hh-mm-ss
#       dt1=MM-DD-YY
#       tm1=HH_MM_SS
#       dt2=MM-DD-YY
#       tm2=HH_MM_SS
#

package NextCAM::Apache::Cam_Alarm;

use strict;
use warnings;

use lib "/opt/sarch/imp/lib/perl/5.8.8";
use lib "/opt/sarch/imp/lib/perl5/site_perl";
use lib "/opt/sarch/common/lib";
use lib "/opt/sarch/fw/bin/perl/FwIface";
use lib "/opt/sarch/fw/bin/perl";
use lib "/opt/sarch/elog/bin/perl";
use lib "/opt/sarch/elog/bin/perl/ELogIface";

use Data::Dumper;
use URI::Escape;

use NextCAM::Conf;
use NextCAM::Servicing::Client;
use FwIface::Types;
use ELog;

my $elog_client = undef;

BEGIN
{
    # temporary solution before splitting NextCAM::Init module on 2 parts
    # use NextCAM::Init;
}

sub handler : method {
    my ($class, $r) = @_;
    
    if (!defined($elog_client))
    {
        #print STDERR "Initializing elog client\n";
        my $service_client = NextCAM::Servicing::Client->new("s_master", 10000);
        $elog_client = ELogClient->new($service_client->getProtocol("skm.eventlog"));
    }

    my $form_info='';
    if ($ENV{REQUEST_METHOD} eq "GET") {
        $form_info = $ENV{QUERY_STRING};
    } else {
        my $size_of_form_information = $ENV{CONTENT_LENGTH};
        read (STDIN, $form_info, $size_of_form_information);
    }


    my %args=map {(lc($1),$2) if /(\S+)=(\S+)/} split /&/,$form_info;


    my $remote_addr=$r->connection()->get_remote_host();

    print STDERR "cam_alarm:[$form_info]: from $remote_addr\n" if $form_info=~/debug/i;

    my $ip='';
    my $objid='';
   

    if (defined $args{objid}) {
        $objid=$args{objid}; 
        my %conf = NextCAM::Conf::GetCfgs('OBJID' => $objid);
        my $devid=(keys %conf)[0];
        if (not defined $devid) {
            error($r, $form_info, "<EVENTLOG>\n<STATUS VALUE='ERROR' MESSAGE='Camera with objid=$args{objid} not found'/>\n</EVENTLOG>\n"); 
            return Apache2::Const::OK;
        }
        $ip=$conf{$devid}->{DEVIP}; 
        #$ip='s_master';   # for a tests
    }elsif (defined $args{devid} || defined $args{dev}) { 
        my $devid=(defined $args{dev})? $args{dev}: $args{devid};
        my %conf = NextCAM::Conf::GetCfgs('DEVID'=>$devid);
        $objid=$conf{$devid}->{OBJID};
        $ip=$conf{$devid}->{DEVIP};
    }else{ 
        error($r, $form_info, "<EVENTLOG>\n<STATUS VALUE='ERROR' MESSAGE='need devid/objid'/>\n</EVENTLOG>\n"); 
        return Apache2::Const::OK;
    }
  
    if($ip ne $remote_addr) {				# IP autorization for event messages 
        error($r, $form_info, "<EVENTLOG>\n<STATUS VALUE='ERROR' MESSAGE='$remote_addr is not authorized'/>\n</EVENTLOG>\n");
        return Apache2::Const::OK;
    }

    my $event_time = time;
    my $msg = defined $args{message} ?  $args{message} : "";

    my $action = Action->new(
             {
              name => "create",
              parameters => {"objid"     => $objid,
                             "source"    => 2,
                             "msg"       => $msg,
                             "when"      => $event_time
                            }
             });

    if (defined $args{interval} and $args{interval}=~/^(\d+):(\d+)$/)
    {
        $action->parameters->{"from"} =  $event_time - $1;
        $action->parameters->{"to"}   =  $event_time + $2;
    }


    my $resp;
    eval
    {
        $resp = $elog_client->submitAction($action);
    };
    if ($@)
    {
        error($r, $form_info, "FwIface::FwException: ". $@->{errorId}.": ".$@->{what}. "\n");
    }
    else
    {
        # FIXME: Do we need to exactly emulate eventlog.cgi behavior?
        html_print($r, $form_info, "<?xml version=\"1.0\"?>\n
                    <EVENTLOG>
                       <STATUS VALUE=\"OK\" MESSAGE=\"No error. New event created\"/>
                    <EVENT EVENTID=\"$resp->{parameters}{eventid}\"/></EVENTLOG>");
    }

    return Apache2::Const::OK;
}


sub error {
    my ($r, $form_info, $txt) = @_;
    html_print($r, $form_info, $txt); 
    print STDERR "cam_alarm:ERROR[$txt]\n";     # if $form_info=~/debug/i;
}

sub html_print {
    my ($r, $form_info, $txt) = @_;
    $r->headers_out->add("Cache-Control", "no-store, no-cache, must-revalidate");
    $r->headers_out->add("Pragma", "no-cache");
    $r->content_type('text/xml');     

    print "$txt";
    print STDERR "cam_alarm:[$txt]\n"            if $form_info=~/debug/i;
}


1;
