#!/usr/bin/perl
#  $Id: os_logger.pl 6458 2006-11-20 00:55:13Z teetov $
# -----------------------------------------------------------------------------
#  Report OS/NEXTcam vital characteristics on periodic basis
# -----------------------------------------------------------------------------
#  Author: Andriy Fomenko
#  Edited by: 
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT LLC 2005
# -----------------------------------------------------------------------------

use strict;
use Log::Log4perl "get_logger";
#require "$ENV{APL}/common/bin/logger.engine";

my $APL=$ENV{APL};                                      # directory structure root
my $APL_CONF=$ENV{APL_CONF};                            # conf-files are here - will be depreciated!!!
my $LOG_CFG_FILENAME = "$APL/common/etc/os_logger.conf";   # logger settings config file
my $LOG_CFG_REFRESH_INTERVAL = 60;                      # logger config refresh interval

Log::Log4perl::init_and_watch($LOG_CFG_FILENAME, $LOG_CFG_REFRESH_INTERVAL);


my $log=get_logger('OS::LOGGER');

my $full_ps_ts = 0;

$log->info("OS logger started");
while(1) {
    $log->info('--------------------------------------------------------------');
    ReportTOP();
    $log->info('--------------------------------------------------------------');
    ReportPS();
    $log->info('--------------------------------------------------------------');
    ReportVMSTAT();
    $log->info('--------------------------------------------------------------');
    ReportMOUNTS();
    $log->info('==============================================================');
    sleep 120;
} # while(1)

# ------------------------------------------------------------- ReportTOP -----
sub ReportTOP {
    my $out = `COLUMNS=512 nice top -cb -n 1 | sed 's/  *\$//' | head -n 30`;
    $log->info("\n$out");
}

# -------------------------------------------------------------- ReportPS -----
sub ReportPS {
    my $msg;
    if (time - $full_ps_ts >= 600) {
	$msg = "[PS FULL]\n".`ps axfu`;
	$full_ps_ts = time;
    }
    else {
	$msg = "[PS SARCH]\n".`ps axfu|grep sarch`;
    }
    $log->info($msg);
}

# ---------------------------------------------------------- ReportVMSTAT -----
sub ReportVMSTAT {
    my $out = `nice vmstat 1 3`;
    $log->info("\n$out");
}

# ---------------------------------------------------------- ReportMOUNTS -----
sub ReportMOUNTS {
    my %mounts;
    eval {
		local $SIG{ALRM} = sub{ die "TIMEOUT $!" };
		alarm 15;
		open(DF,'nice mount|');
		while(<DF>) {
			chomp;
			# /dev/hda4 on /opt/sarch/store type reiserfs (rw)
            # $1 => /dev/hda4
            # $2 => /opt/sarch/store
            # $3 => reiserfs 
            # $4 => (rw)
			if ( /^(\S+)\s+on\s+(\S+)\s+type\s+(\S+)\s+(\S+)/ ) {
			    $mounts{$2}{DEV} = $1;
			    $mounts{$2}{FS} = $3;
			    $mounts{$2}{RW} = $4;
		    }
		}
		close DF;
		open(DF,'nice df|grep -v Filesystem|'); # cut header
		my $longline = "";
		my $line = "";
		while(<DF>) {
			chomp;
			if ( /^\/{1,2}[^\/]+\/\S+$/ )
			{
				$longline = $_;
				next;
			}
			if ( $longline ) { $line = "$longline $_"; $longline = ""; }
			else { $line = $_; }
			next if not $line =~ /^(\S+)\s+(\d+)\s+(\d+)\s+(\d+)\s+\d+\%\s+(.*)/;
            # Filesystem           1K-blocks      Used Available Use% Mounted on
            # /dev/hda4              8184448     32844   8151604   1% /opt/sarch/store
			next if not $5;
			$mounts{$5}{SIZE} = $2;
			$mounts{$5}{AVAIL} = $4;
		};
		close DF;
    };
    $log->error('ReportMOUNTS:',$@) if $@;
    alarm 0;
    my $out = '';
    foreach my $mount ( keys %mounts ) {
        $out .= sprintf("\n%-25s dev=%-12s avail=%-12s size=%-12s fs=%-10s rw=%s",$mount,$mounts{$mount}{DEV},$mounts{$mount}{AVAIL},$mounts{$mount}{SIZE},$mounts{$mount}{FS},$mounts{$mount}{RW});
    }
    $log->info($out);
}
