#!/usr/bin/perl
#  $Id: restart_xview.pl 6458 2006-11-20 00:55:13Z teetov $
# -----------------------------------------------------------------------------
#  Restart XViews periodically to temporarily fix fps degradation
# -----------------------------------------------------------------------------
#  Author: Dmitriy Astaltsev
#  Edited by: 
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------

use strict;
use MIME::Base64();
use IO::Socket::INET;
use NextCAM::Init;

my $DEBUG=0;
my $lookback=$ARGV[0] || 90;
my ($APL,$APL_CONF)=($ENV{APL},$ENV{APL_CONF});
my ($total,$cnt);

my $interval = shift || 180; # 3 hours on default
$interval *= 60; # convert to seconds

my %conf =  GetCfgs( ('CAMERAMODEL'=>'Xview') );

my $usrpsw;

print "Restarter started ;)\n";

while(1) {
  foreach my $dev ( sort keys %conf ) {
    print "Resetting $conf{$dev}{DEVIP}\n";
    $usrpsw = "$conf{$dev}{USRNAME}:$conf{$dev}{PASSWD}";
    checkURL("http://$conf{$dev}{DEVIP}/admin/restart.cgi");
  }
  sleep $interval;
}

# -------------------------------------------------------------- checkURL -----
sub checkURL {
  my @answ;
  my $val=-2;
  my($url)=@_;  #print "URL: $url\n";
  my($server,$port,$path)=($url=~/^http:\/\/([\w\.]+):?(\d+)?\/(.*)/)? ($1,$2,$3):('','');
  $port = 80 if not $port;
  my $iaddr = inet_aton($server) || die "no host: $server";
  my $paddr = sockaddr_in($port, $iaddr);
  my $proto = getprotobyname('tcp');
  my $auth=($usrpsw)?"\nAuthorization: Basic ". MIME::Base64::encode($usrpsw,''):'';

  eval {
    local $SIG{ALRM}=sub{die 'ALARM'};
    alarm 2;
    socket(SOCK, PF_INET, SOCK_STREAM, $proto) || die "socket: $!";
    connect(SOCK, $paddr) || die "connect: $!";
    autoflush SOCK;
    my $get=qq(GET /$path HTTP/1.0$auth
Accept: image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png
Accept-Charset: iso-8859-1,*,utf-8
Accept-Encoding: gzip
Accept-Language: en
User-Agent: Mozilla/4.76 [en] (X11; U; Linux 2.2.16 i686)

);
    print SOCK $get;
    $val = -1;
    @answ=<SOCK>; # print "@answ\n";
    close (SOCK);
    alarm 0;
  } or $val=-2; # eval
  alarm 0;
  foreach (@answ) { next if not /.+=(\d)/; return $1; }
  return $val;
} # sub checkURL


# ------------------------------------------------------------------ debug -----
sub debug
{
  print STDERR "DEBUG @_\n" if $DEBUG>=shift
} # sub debug

# ----------===== Changes log =====----------
# $Log$
# Revision 1.2  2004/07/02 20:54:19  afomenko
# Added standard comments
#