#!/usr/bin/perl
#  $Id: DrawRedX.pl 7183 2007-01-29 21:13:19Z teetov $
# -----------------------------------------------------------------------------
#  Add Red X to given picture
# -----------------------------------------------------------------------------
#  Author: Serg Pososhenko
#  Edited by:
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------

use strict;
use FileHandle;
use Log::Log4perl "get_logger";

require "$ENV{APL}/common/bin/logger.patrol";
my $log = get_logger('NEXTCAM::CAM::REDX');
my $IMAGE = shift;

$log->warn('Draw RED X on the image:', $IMAGE);
my $img_params = get_image_params("$IMAGE"); # Check image properties
my $geometry = (${$img_params}{GEOMETRY} =~ /\d+x\d+/i) ? ${$img_params}{GEOMETRY} : "320x240";
my $w_x = 0.125;
my $w_y = 0.125;
my ($width, $height) = split("x", $geometry);
$w_x = sprintf("%.0f", $w_x * $width);
$w_y = sprintf("%.0f", $w_y * $height);
my $X_shape = "polygon 0,$w_y $w_x,0 " . sprintf("%.0f", $width / 2) . "," . sprintf("%.0f", $height / 2 - $w_y) . " ";
$X_shape .= ($width - $w_x) . ",0 $width,$w_y " . sprintf("%.0f", $width / 2 + $w_x) . "," . sprintf("%.0f", $height / 2) . " ";
$X_shape .= "$width," . ($height - $w_y) . " " . ($width - $w_x) . ",$height " . sprintf("%.0f", $width / 2) . "," . sprintf("%.0f", $height / 2 + $w_y) . " ";
$X_shape .= "$w_x,$height 0," . ($height - $w_y) . " " . sprintf("%.0f", $width / 2 - $w_x) . "," . sprintf("%.0f", $height / 2);
system("nice montage -quality 30 -geometry $geometry -fill red -draw '$X_shape' $IMAGE $IMAGE");


sub get_image_params {
    my $image = shift;
    my $line = `identify $image`;
    my @lines=split(/\s/, $line);
    my %parameters;

    my @liness=split(/\+/, $lines[2]);
    $parameters{'GEOMETRY'} = $liness[0];
    return \%parameters;
}