KeepAlive On
MaxKeepAliveRequests 0
KeepAliveTimeout 15

LimitRequestFields 100
LimitRequestFieldSize 8190
LimitRequestLine 8190

ServerSignature Off
TraceEnable Off

DirectoryIndex index.htm index.html index.php

AddType text/xml .xml
AddType application/xslt+xml .xsl
AddType application/json .json
AddType text/javascript .js
AddType text/css .css
AddType image/vnd.microsoft.icon .ico
AddType application/x-msi .msi
AddType application/x-apple-diskimage .dmg

# TBD: define /opt/sarch APL APL_CONF PERL5LIB with env.conf
SetEnv APL /opt/sarch
SetEnv APL_CONF /var/sarch/conf
SetEnv APL_VAR /var/sarch
SetEnv APL_MOD STRATUS
SetEnv VERSIONER_PERL_VERSION 5.8.9
SetEnv PERL5LIB /opt/sarch/common/lib:/opt/sarch/imp/lib/perl5/site_perl:/opt/sarch/imp/lib/perl:/opt/sarch/imp/lib/perl5/site_perl/5.8.8:/opt/sarch/imp/lib/perl/5.8.8

## Cross-origin Resource Sharing (CORS) -- http://www.w3.org/TR/cors
## For 3rd party party requests to authmng.php
## Defining APL_CORS_ALLOW will activate.
## Sample:
# SetEnv APL_CORS_ALLOW http://www.otherdomain.com

## Allow passing of session ID via URL paramater in authmng.php
## Workaround for CORS withCredentials support on IE8/9/10(?)
## Uncomment below to activate:
# SetEnv APL_CORS_SID_ALLOW 1

<IfModule mod_deflate.c>
    # force deflate for mangled headers
    # developer.yahoo.com/blogs/ydn/posts/2010/12/pushing-beyond-gzipping/
    <IfModule mod_setenvif.c>
        <IfModule mod_headers.c>
            SetEnvIfNoCase ^(Accept-EncodXng|X-cept-Encoding|X{15}|~{15}|-{15})$ ^((gzip|deflate)\s*,?\s*)+|[X~-]{4,13}$ HAVE_Accept-Encoding
            RequestHeader append Accept-Encoding "gzip,deflate" env=HAVE_Accept-Encoding

            SetEnvIfNoCase Request_URI \.(?:gif|jpe?g|png)$ no-gzip dont-vary
            SetEnvIfNoCase Request_URI \.(?:exe|t?gz|zip|bz2|sit|rar)$ no-gzip dont-vary
            SetEnvIfNoCase Request_URI \.pdf$ no-gzip dont-vary
        </IfModule>
    </IfModule>

    <IfModule mod_filter.c>
        AddOutputFilterByType DEFLATE text/text text/html text/plain text/xml text/css application/xhtml+xml application/xml application/xslt+xml application/x-javascript application/javascript text/javascript application/json
    </IfModule>
</IfModule>

# Deny access to filesystem by default, then explictly allow videoNEXT web resources
<Directory />
    AllowOverride None
    Options None
    Order deny,allow
    Deny from all

    # Disable methods like PUT, DELETE, etc.
    <LimitExcept GET POST OPTIONS>
        Order allow,deny
        Deny from all
    </LimitExcept>
</Directory>

<Location />
    # Disable methods like PUT, DELETE, etc.
    <LimitExcept GET POST OPTIONS>
        Order allow,deny
        Deny from all
    </LimitExcept>
</Location>

# base/www/common is used as a storage for binary plugins and other resources
Alias /common/ /opt/sarch/base/www/common/

Alias /wheels/MediaPlayer.jar        /opt/sarch/base/www/common/activex/MediaPlayer.jar
Alias /wheels/MediaPlayerLoader.jar  /opt/sarch/base/www/common/activex/MediaPlayerLoader.jar
Alias /wheels/MediaPlayer.linux.jar  /opt/sarch/base/www/common/activex/MediaPlayer.linux.jar
Alias /wheels/MediaPlayer.macosx.jar /opt/sarch/base/www/common/activex/MediaPlayer.macosx.jar
Alias /wheels/MediaPlayer.win32.jar  /opt/sarch/base/www/common/activex/MediaPlayer.win32.jar

<Location /common/activex/>
    Header set Cache-Control "must-revalidate, max-age=0"
    <IfModule mod_expires.c>
        ExpiresActive On
        ExpiresDefault "access plus 3 hours"
        ExpiresByType application/zip "now"
    </IfModule>
</Location>

<Directory /opt/sarch/base/www/common>
    AllowOverride None
    Require all granted
</Directory>

Alias /wheels/eLogClientApplet.jar   /opt/sarch/elog/bin/eLogClientApplet.jar
Alias /wheels/elogiface.jar          /opt/sarch/elog/bin/elogiface.jar

<Directory /opt/sarch/elog/bin>
    AllowOverride None
    <Files ~ "(eLogClientApplet\.jar|elogiface\.jar)" >
        Require all granted
    </Files>
</Directory>

Alias /wheels/json.jar               /opt/sarch/imp/lib/json.jar

<Directory /opt/sarch/imp/lib>
    AllowOverride None
    <Files json.jar>
        Require all granted
    </Files>
</Directory>

Alias /wheels/libfwiface.jar         /opt/sarch/fw/bin/libfwiface.jar

<Directory /opt/sarch/fw/bin>
    AllowOverride None
    <Files libfwiface.jar>
        Require all granted
    </Files>
</Directory>

Alias /wheels/libomiface.jar         /opt/sarch/om/bin/libomiface.jar

<Directory /opt/sarch/om/bin>
    AllowOverride None
    <Files libomiface.jar>
        Require all granted
    </Files>
</Directory>

Alias /wheels/libthrift.jar          /opt/sarch/imp/lib/libthrift.jar

<Directory /opt/sarch/imp/lib>
    AllowOverride None
    <Files libthrift.jar>
        Require all granted
    </Files>
</Directory>

Alias /wheels/Messenger.jar          /opt/sarch/mbus/bin/Messenger.jar

<Directory /opt/sarch/mbus/bin>
    AllowOverride None
    <Files Messenger.jar>
        Require all granted
    </Files>
</Directory>

Alias /wheels/serviceapi.jar         /opt/sarch/fw/bin/serviceapi.jar

<Directory /opt/sarch/fw/bin>
    AllowOverride None
    <Files serviceapi.jar>
        Require all granted
    </Files>
</Directory>

Alias /wheels/vCrypt/                /opt/sarch/imp/html/wheels/vCrypt/

<Directory /opt/sarch/imp/html/wheels/vCrypt>
    AllowOverride None
    Require all granted
</Directory>

# /wheels
<IfModule mod_rewrite.c>
    RewriteEngine On
    RewriteRule ^/wheels/va-stratus-3.9.17-1.el7/(.*)$ /wheels/$1 [PT]
</IfModule>
