#!/usr/bin/perl
#
#  $Id: sos-updates.pl 25111 2012-02-01 23:15:36Z teetov $
#
#  purpose:
#   1. find rpm for update on USB attached drive
#   2. run rpm -U for that package
#  note: 
#   - script runs from root
#   - linux specific
#

my $APL='/opt/sarch';
my $VERSION=`$APL/vpatch/bin/vctl label`; chomp $VERSION;
my $VERID  =`$APL/vpatch/bin/vctl verid`;
my $LIST='/sbin/fdisk -l 2>/dev/null';
my $MNT="/tmp/mnt$$";

# PRE-CHECKS ---------------------------------------
die("\nVERSION is not defined or software is not installed\n") if ! $VERSION;
die("\nShould be run by root\n") if ($<!=0);
mkdir($MNT,0755) || die "Cannot create mountpoint $MNT";
my ($templ_name)=$VERSION=~/^(va-\w+-\d+\.\d+)\.\d+-/;
die("\nCannot calculate rpm name\n") if not $templ_name;

# SUBS ---------------------------------------------
sub check_dir {
   $mpoint=shift;
   opendir(DIR,$mpoint) || die "Cannot read dir $mpoint";
   my @dir= sort grep { /^$templ_name\.\S+\.rpm$/ } readdir(DIR);
   closedir DIR;
   return '' if ! @dir;
   return "$mpoint/$dir[-1]";
}

sub check_repo {
  $mpoint=shift;
  my $repo="$mpoint/va-updates";
  return $repo if -d $repo;
  return '';
}

sub check_usb {
   print "\n\n--------------------------------------------------------------";
   print "[Instruction]--\n";
   print "Place latest $templ_name.*.rpm on USB-flash drive in va-updates directory\n";
   print "then insert flash drive to USB socket on the server\n";
   print "\nPress ENTER when ready\n";
   <STDIN>;
   #-------------------------------------------------------prepare mount list
   my @list;
   open(LIST,"$LIST|") || die "Cannot do $LIST: $@";
   foreach(<LIST>) {
     push(@list,$1) if m|^(/dev/sd\w?\d)\s.+FAT\d?\d?|;
     push(@list,$1) if m|^Disk\s(/dev/sd\w?):\s+(\d\d\d\d?)\sMB|;
   }
   close LIST;
   return '' if ! @list;
   print "Candidates: ". join(' ',@list). "\n";
   open(MOUNT,"mount|") || die "Cannot run mount";
   my %mounted= map{m|(/dev/s\w+\d)\son\s(\S+)\s|} grep {m|^/dev/sd\w\d\son\s\S+\s|} <MOUNT>;
   close MOUNT;
   my $repo;
   #-------------------------------------------------------------try to mount 
   foreach(@list) {
      my $mpoint=$MNT;
      if(defined $mounted{$_}) { # already mounted
        $mpoint=$mounted{$_};
      }else {                
       `umount $MNT 2>/dev/null; mount -r $_ $MNT 2>/dev/null`;
        next if $?;                       # mount fails
      }
      
      if(-d "$mpoint/va-updates") {
        $repo="$mpoint/va-updates";
        last;
      }
   }
   return $repo;
}

# MAIN =============================================
my $rpm;

$repo=check_repo('/mnt');
if(!$repo) {
  $repo=check_usb;
}
if($repo) {
   # ------------- take
   print "\n\tFound:\t$repo\n\nPress ENTER for starting update";
   <STDIN>;
#     yum -y -c /tmp/19989.repo --disablerepo=* --enablerepo=update_va clean all
#     yum -y -c /tmp/19989.repo --disablerepo=* --enablerepo=update_va update
#     rpm -U /mnt/va-updates/va-stratus-3.6.0-25093_20120201.el5.i386.rpm

   # create repository configuration:
   open(REPO,">/tmp/$$.repo");
   print REPO "[update_va]\nname=va update\n"
             ."baseurl=file://$repo\ngpgcheck=0\n";
   close REPO;
   system("service patrol stop");
   system("yum -y -c /tmp/$$.repo --disablerepo=* --enablerepo=update_va clean all");
   system("yum -y -c /tmp/$$.repo --disablerepo=* --enablerepo=update_va update");
   my $rpm=check_dir($repo);
   if($rpm) {
     system("rpm -U $rpm");
   }
   `umount $MNT 2>/dev/null`;  # just in case, it may be not mounted 
   unlink "/tmp/$$.repo";
}else {
   print "Nothing was found\n";
}
print "-----------------------------------------------------------------------------\n";
print "Press ENTER";
<STDIN>;
