#!/usr/bin/perl
#  $Id: httpd_conf_patches.pl 27576 2012-12-18 17:36:43Z teetov $
# -----------------------------------------------------------------------------
# Script to patch httpd.conf file
# You can add as many patches as you want to %patches!
# DO NOT FORGET TO USE \ WITH SYMBOLS LIKE %,@,$ or use '' instead of ""
#
# To remove ALL patches from file just run "httpd_conf_patches.pl remove"
# -----------------------------------------------------------------------------
#  Author: Dmitri Astaltsev (c) 2003
#  Edited by: Dmitriy Astaltsev, Kostadin Kanchev, A Teetov
#  QA by:  Christopher C Gettings
#  Copyright: videoNEXT LLC
# -----------------------------------------------------------------------------

use strict;
my $file2patch = $ENV{HTTPD_CONF};

my %patches = (
	"TRACE"	=> ""
);

if ($ENV{TARGET_OS} eq "Darwin")
{
  if ($ARGV[0] =~/remove/i) {
      `sed -i -e 's|^#Include.*\/etc\/apache2\/sites\/\\*\\.conf.*|Include "/etc/apache2/sites/*.conf"|' /etc/apache2/httpd.conf`;
   #   `sed -i -e "s|LoadModule php5_module libexec\/apache2\/libphp5\\.so|#LoadModule php5_module libexec/apache2/libphp5.so|" /etc/apache2/httpd.conf`;
  }
  else {
    # OS X Server does not have /etc/apache2/other directory.
    if ( ! -d "/etc/apache2/other" ) {
      mkdir "/etc/apache2/other", 0755;
    }

    if ( ! `grep -e "^Include.*\/private\/etc\/apache2\/other\/\\*\\.conf" /etc/apache2/httpd.conf 2>/dev/null` ) {
      $patches{TRACE}=$patches{TRACE}."\nInclude /etc/apache2/other/*.conf";
    }

    # OS X Server: comment Include "/etc/apache2/sites/*.conf" because it breaks our settings
    # should be uncommented again when deinstall
    if ( `grep -e '^Include.*\/etc\/apache2\/sites\/\\*\\.conf.*' /etc/apache2/httpd.conf 2>/dev/null` ) {
      `sed -i -e 's|^Include.*\/etc\/apache2\/sites\/\\*\\.conf.*|#Include "/etc/apache2/sites/*.conf"|' /etc/apache2/httpd.conf`;
    }

    if ( ! `grep -e '^Listen .*80' /etc/apache2/httpd.conf 2>/dev/null` ) {
      $patches{TRACE}=$patches{TRACE}."\nListen *:80\nDirectoryIndex index.html index.php";
    }

    # OS X Server: enabling php5_module
    `sed -i -e "s|#LoadModule[ \t]*php5_module[ \t]*libexec\/apache2\/libphp5\\.so|LoadModule php5_module libexec/apache2/libphp5.so|" /etc/apache2/httpd.conf`;
  }

}
%patches = () if $ARGV[0] =~/remove/i;

if (-f $file2patch) {
   my @lines = ();
   open(F,"<$file2patch");
   while (<F>) {
      push(@lines,$_);
   }
   close(F);
   open (NF,">$file2patch");
   foreach(@lines){
   print NF $_ if not /#\sBEGIN\sPATCH/ .. /#\sEND\sPATCH/;
   }

   foreach my $PATCH (keys %patches){
   print NF <<END_PATCH;
# BEGIN PATCH $PATCH ##################
$patches{$PATCH}
# END PATCH $PATCH ##################
END_PATCH
   }
   close(NF);
} else {
   print "No such file $file2patch !\n";
}

# ----------===== Changes log =====----------
# $Log$
# Revision 1.4  2004/06/10 19:37:03  afomenko
# CR/LF -> LF
#
# Revision 1.3  2004/06/08 22:17:51  afomenko
# Added header/trailer with copyright, id, log
#
