#!/usr/bin/perl
use Net::SMTP;
use MIME::Base64 ();
use SKM::DB;
use XML::Simple;
use JSON;
use NextCAM::Init;
use Data::Dumper;
use CGI qw (unescape);
use Log::Log4perl "get_logger";
require "$ENV{APL}/common/bin/logger.engine";

my $log=get_logger('NEXTCAM::EMAILER');

$log->info('Starting Emailer');

$SIG{HUP} = 'ReadCfg';

my %asrv = GetAsrv();
my $sleepTime=100000;
my $smtp_server;
my $user_addr;
my $user_name;
my $user_pwd;

my $xs1 = XML::Simple->new();
my $doc;
my $host='localhost';
my @policys;
my $alertFile="$ENV{APL}/var/alert/emailer/alert";
my $ipadr = $asrv{IP};

if (not $ipadr) {
	for($^O) {
		/darwin/i && do {
			my @a =`/sbin/ifconfig |grep -oE "inet [0-9]+\.[0-9]+\.[0-9]+\.[0-9]+"|cut -d ' ' -f 2|grep -v "127.0.0.1"`;
			$ipadr = $a[0];
		};
		/linux/i && do {
			$_ = `/sbin/ifconfig eth0`;
			$ipadr=$1 if /inet ((\d+\.){3}\d+)/;
		};
	}
}

my $alert;

ReadCfg();

while (1)
{
	my $currTime = time;
	my $sleepTime = 1;
	if (defined(@policys[0]) && defined(@policys[0]->{TIME}{VALUE}))
	{
		$sleepTime = @policys[0]->{TIME}{VALUE};
	}
	foreach my $dbemail (@policys)
	{
		my $timeBetweenSending = $dbemail->{TIME}{VALUE};
		if (!defined($dbemail->{TIME}{VALUE}))
		{
			$timeBetweenSending = 0;
		}
		# calculate time for sleep - min from all polices
		if ($timeBetweenSending < $sleepTime)
		{
			$sleepTime = $timeBetweenSending;
		}
		if (!defined($dbemail->{lastaccess}))
		{
			$dbemail->{lastaccess} = $currTime;
		}

		$log->debug("last access was $dbemail->{lastaccess} sec");

		my $delta = $currTime - $dbemail->{lastaccess};
		if ($delta >= $timeBetweenSending)
		{
			my $isReported = 0;
			if ($dbemail->{LEVEL} eq 'EVENT')
			{
				if (-f "$alertFile")
				{
					my $alertFileBak = "$ENV{APL}/var/alert/emailer/alert.bak";
					`mv $alertFile $alertFileBak`;
					open(FALERT, "$alertFileBak")|| $log->die("can\'t read event file");
					while (<FALERT>)
					{
						$alert .= $_;
					}
					close FALERT;
					$isReported = report($dbemail->{LEVEL}, $dbemail->{lastaccess}, $dbemail->{EMAILS}{VALUE});
					`rm -rf $alertFileBak`;
				}
			} else {
				$isReported = report($dbemail->{LEVEL}, $dbemail->{lastaccess}, $dbemail->{EMAILS}{VALUE});
			}
			if ($isReported)
			{
				$dbemail->{lastaccess} = $currTime;
			}
		}
	}
	#sleep at least 1 second
	$sleepTime = 10 if ($sleepTime < 10);
	$log->debug("we must sleep for $sleepTime sec");
	sleep $sleepTime;
}

# ----------------------------------------------------------------- report -----
# building report
sub report{
	my ($loglevel, $per, $toEmail) = @_;
# Need unescape email
	$toEmail = unescape($toEmail);
	$log->debug("report: $loglevel, $per, $toEmail");
	my $isReported = 0;
	my $repstr;
	my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime($per); $year %= 100; $mon++;
	my $tmpstmp = sprintf("20%02d-%02d-%02d %02d:%02d:%02d",$year,$mon,$mday,$hour,$min,$sec);
	($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = gmtime(time); $year %= 100; $mon++;
	my $curtmp = sprintf("20%02d-%02d-%02d %02d:%02d:%02d",$year,$mon,$mday,$hour,$min,$sec);

	my $subj = "list of events level=$loglevel from $tmpstmp to $curtmp\n\n";

	if ($loglevel ne 'EVENT')
	{
		my $query = 
			"SELECT a.date, l.name, c.digest, a.parameters, o.udid, u.name " .
              "FROM audit a " .
			 "INNER JOIN auditcategory c ON c.category = a.category " .
			 "INNER JOIN auditlevel l ON l.level = a.level " .
			 "LEFT JOIN _objs o ON o.obj = a.objid AND COALESCE(c.parent,0) != 16 " .
			 "LEFT JOIN _objs u ON u.obj = a.userid ".
			 "WHERE a.date > \'$tmpstmp\' and l.name = \'$loglevel\' ".
			 "ORDER BY 1";

		#$log->debug("report: query-> $query");
		$dbh1 = DBMaster({PrintError => 1}) || $log->logdie($DBI::errstr);
		my @dbrep = @{$dbh1->selectall_arrayref($query)};
		$dbh1->disconnect();
		my $username = '[System]';
		if(scalar(@dbrep))	{
			foreach my $row (@dbrep) {
				$username = '[System]';
				if ($row->[5]) {
					$username = '[' .$row->[5] . ']';
				}	
#				$repstr .= sprintf("%.22s  %s  %s", $row->[0], $row->[1], formatAuditMessage($row->[2], $row->[3]));
				$repstr .= sprintf("%.22s  %s  %s", $row->[0], $username, formatAuditMessage($row->[2], $row->[3]));
				if ($row->[4] || $row->[5]) {
					$repstr .= ' [';
					$repstr .= 'device=' . $row->[4] . ' ' if ($row->[4]);
					$repstr .= 'user=' . $row->[5] if ($row->[5]);
					$repstr .= ']';
				}
				$repstr .= "\n";
			}

			print $repstr;
		}
	}
	else
	{
		$repstr = $alert;
	}
	$log->debug("report: $loglevel, $repstr");
	if (scalar($repstr))
	{
		my @AddressList = split(/;/,$toEmail);
		foreach my $Addr ( @AddressList)
		{
			my $header = 'EVENT REPORT from the server:'."$ipadr\n\n$repstr";
			$isReported = MailOut($Addr, $subj, $header);
		}
		$repstr = ''; $alert = '';
	}
	return $isReported;
}

# ----------------------------------------------------------------- MailOut -----
# send Email
sub MailOut{
	my ($E_adr, $subj, $mail_body)=@_;
	$log->info("Sending message To:$E_adr Subj:$subj");

	my $isSended = 0;
	$smtp = Net::SMTP->new(
		Host => $smtp_server,
		Port => 25,
		Timeout => 5,
		Debug => 1
	);
	if ($smtp)
	{
		print "created";
		if ($smtp->auth($user_name, $user_pwd))
		{
			$isSended = 1;

			$smtp->mail($user_addr);
			$smtp->to($E_adr);

			$smtp->data();
			$smtp->datasend("From: $user_name\n");
			$smtp->datasend("To: $E_adr\n");
			$smtp->datasend("Subject: $subj\n");
			$smtp->datasend("\n");
			$smtp->datasend("\n");
			$smtp->datasend($mail_body);
			$smtp->datasend("\n");
			$smtp->datasend("\n");
			$smtp->datasend();
			$smtp->quit;
		} else {
			$log->info("Cannot authenticate to $smtp_server. Wrong user name or password\n");
		}
	} else {
		 $log->info("Cannot connect to $smtp_server\n")
	}
	return $isSended;
}# send Email

#========================== reading API XML config data======================================
sub ReadCfg
{
	$query = "SELECT * from dyna_data where typeid='Emailer';";
	my $dbh=DBMaster({PrintError => 1})|| $log->logdie($DBI::errstr);
	my $dbreturns=$dbh->selectall_hashref($query, 'ind');
	my $input = "";

	if (!$dbreturns)
	{
		$input .= "<DYNADATA>\n\t<STATUS VALUE=\"ERROR\" MESSAGE=\"DB access error\"/>\n</DYNADATA>\n";
		$log->logdie($DBI::errstr);
	}
	$dbh->disconnect();

	my $ee = scalar(%$dbreturns);
	if ($ee ne 0)
	{
		$input .= "<DYNADATA>\n\t<STATUS VALUE=\"OK\" MESSAGE=\"Query successful\"/>\n";

		foreach my $dbrow ( keys %$dbreturns )
		{
			$input .= "\t<DATABLOCK BLOCKID=\"$dbreturns->{$dbrow}{ind}\" TYPEID=\"$dbreturns->{$dbrow}{typeid}\" CONTENTID=\"$dbreturns->{$dbrow}{contentid}\" DESCRIPTION=\"$dbreturns->{$dbrow}{description}\">\n";
			$input .= "\t\t<LAYOUT>$dbreturns->{$dbrow}{data}</LAYOUT>\n\t</DATABLOCK>\n";
		}
		$input .= "</DYNADATA>\n";
	}
	else
	{
		$input = "<DYNADATA>\n<STATUS VALUE=\"OK\" MESSAGE=\"No one Dynamic Data block exist\"/>\n</DYNADATA>\n";
	}

	$doc = $xs1->XMLin($input, ForceArray=>["POLICY"],KeyAttr=>[]);
	$smtp_server = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{SERVER});
	$user_addr = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{EMAIL});
	$user_name = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{USER});
	$user_pwd = unescape($doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{CONFIG}->{PASSWORD});
	@policys = @{$doc->{DATABLOCK}->{LAYOUT}->{RESULT}->{POLICY}};
	$log->info("Config read as SMTP_Server:$smtp_server Login:$user_name");
	#$log->debug(Dumper(@policys));
}
#========================== end reading API XML config data======================================


#
# Returns formatted audit message (insert parameters into message digest)
#
sub formatAuditMessage {
	my ($digest, $parameters) = @_;
    my $msg = "";

	if ($digest) {
		$msg = $digest;

		if ($parameters) {
			eval {
				# parse JSON string,
				# get list of parameters (first nested array)
				# and replace placeholders (%1, %2, %3, ...)

				my $parametersJson = from_json($parameters, {utf8  => 1});
				if (ref($parametersJson) eq 'ARRAY' &&  $#{$parametersJson} >=0) {

					my $msgParamsRef = $parametersJson->[0];
					if (ref($msgParamsRef) eq 'ARRAY' &&  $#{$msgParamsRef} >=0) {

						my $i = 1;
						foreach my $param (@{$msgParamsRef}) {
							$msg =~ s/%$i/$param/g;
							$i++;
						}
					}
				}
			};
			if ($@) {
				# $log->warn($@)
				print "Failed to parse json: '$@'";
			}
		}

		# remove all unassigned placeholders
		$msg =~ s/%{1}\d{1,}//g;
	}

	return $msg;
}
