<?
//  $Id: video.php 8461 2007-08-08 17:01:20Z abara $
// -----------------------------------------------------------------------------
//  Library to provide common video player[s] primitives.
// -----------------------------------------------------------------------------
//  This library MUST be included after opening <HTML> tag but before <BODY> tag,
//  since it genertates certain amount of JavaScript code just by include and
//  before any function was even called
// -----------------------------------------------------------------------------
//  Authors: Andriy Fomenko / Jeremiah Morrill / Andriy Baranetsky
//  Edited by:
//  QA by:  Christopher C Gettings
//  Copyright: videoNEXT Network Solutions Inc 2006
// -----------------------------------------------------------------------------

?>
<script src="/api/scripts/MPlayer2.js"></script>
<script src="/api/scripts/DateUtils.js"></script>
<?

require_once $_SERVER['APL'] . '/api/lib/php/bootstrap.php';

/**
 * This call creates necessary HTML elements for live video player.
 *
 * It is important for this call to receive unique "htmlObjId" which will be used
 * to place object[s] into the page. This "htmlObjId" will be used to control
 * player later on.
 *
 * Since it may be nothing known about stream, it is expected that such
 * knowledge will be passwd in the $options parameter, where next keys
 * will be processed (separated by comma):
 * framework=X.X.X           default 2.4
 * width=XXX (pixels)        default '320'
 * height=XXX (pixels)       default '240'
 * initstate=[Idle|Snapshot|Play] default 'Idle'
 * ts_from                   'yyyy-mm-dd hh-mm-ss'
 * ts_to                     'yyyy-mm-dd hh-mm-ss'
 *
 * @param string $htmlObjId
 * @param int    $objid
 * @param string $options
 * @return string
 */
function videoPlayer($htmlObjId, $objid, $options='')
{
    // apply defaults
    $args = Array();
    $args['FRAMEWORK'] = 2.4;
    $args['WIDTH'] = 320;
    $args['HEIGHT'] = 240;
    $args['TOOLBAR'] = 'StartStop|FullScreen';
    $args['INITSTATE'] = 'Idle';
    $args['CACHESIZEMB'] = 4;
    $args['ANALYTICS'] = null;
    $args['IMAGECALLBACKS'] = '1';
    // process options on the top of defaults
    foreach(explode(',',$options) as $pair) {
        list($key,$value) = explode('=',trim($pair));
        $value = trim($value);
        if ( $value != '') {
          $args[strtoupper(trim($key))] = trim($value);
        }
    }

    // now depending on browser type, framework revision and so on - embed correspondent player
    if ($args['FRAMEWORK'] >= 2.4)
    {
      return drawVideoNEXT($htmlObjId, $objid, $args);
    }
    else
    {
      exit('video.php::videoPlayer supports version 2.4 and later');
    }
}

/**
 * drawVideoNEXT player
 *
 * @param string $htmlObjId
 * @param int    $objid
 * @param array  $args
 * @return string
 */
function drawVideoNEXT($htmlObjId, $objid, array $args)
{
  // Generate player initialization code
  //
  $internPlayerVar = '_mplayer_' . $htmlObjId;
  $appletInitTag = '';

  $videoHelper = new VideoHelper();
  if ($objid !== NULL)
  {
    // define context type
    $errMsg = '';
    $params = array();
    $params['PLAYER'] = 'MPLAYER';
    $params['OBJID'] = $objid;

    $initstate = strtoupper($args['INITSTATE']);
    $contextType = null;
    if ($initstate == 'SNAPSHOT') {
      $contextType = 1;
      $params['STREAMTYPE'] = 'snapshot';
    } else {
      if (empty($args['TS_FROM'])) {
        $params['STREAMTYPE'] = 'live';
        $contextType = 2;
      }
      else {
        $params['STREAMTYPE'] = 'archive';
        $params['TIME_START'] = $args['TS_FROM'];
        if (!empty($args['TS_TO'])) {
          $params['TIME_END'] = $args['TS_TO'];
        }
        $contextType = 3;
      }
    }

    if(!empty($args['ANALYTICS'])){
      $params['ANALYTICS'] = $args['ANALYTICS'];
    }
    if(!empty($args['AUDIOOBJID'])){
      $params['AUDIOOBJID'] = $args['AUDIOOBJID'];
    }
    if(!empty($args['EVENTID'])){
      $params['EVENTID'] = $args['EVENTID'];
    }
    if(!empty($args['NOAUDIT'])){
      $params['NOAUDIT'] = $args['NOAUDIT'];
    }
    if(isset($args['STREAMNUM'])){
      $params['STREAMNUM'] = $args['STREAMNUM'];
    }
	if(isset($args['SKIP_GAPS'])){
      $params['SKIP_GAPS'] = $args['SKIP_GAPS'];
    }

    // setContext
    $appletInitTag .= "${internPlayerVar}.setContext(${objid}, ${contextType}";
    if ($contextType == 3) {
      try {
        $mts = $videoHelper->parseTimestamp($params['TIME_START']);
      }
      catch (Exception $e) {
        $errMsg = $e->getMessage();
      }
      $appletInitTag .= ", ${mts}000";
      try {
        $mts = $videoHelper->parseTimestamp($params['TIME_END']);
      }
      catch (Exception $e) {
        $errMsg = $e->getMessage();
      }
      $appletInitTag .= ", ${mts}000";
    }
    $appletInitTag .= ");\n";

    try {
      $videoHelper->getDeviceInfo($params);
      $bOk = true;
    }
    catch (Exception $e) {
      $bOk = false;
      $errMsg = $e->getMessage();
    }

    if ($bOk) {
      $appletInitTag .= "    ${internPlayerVar}.setParameter('DEVICE_TYPE', '${params['DEVICE_TYPE']}');\n";
      if (!empty($params['TIME_ZONE'])) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('TIME_ZONE', '${params['TIME_ZONE']}');\n";
      }
      if (!empty($params['AUDIOOBJID'])) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('AUDIOOBJID', '${params['AUDIOOBJID']}');\n";
      }
      if (!empty($params['FRAMERATE'])) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('FRAMERATE', '${params['FRAMERATE']}');\n";
      }
      if (!empty($params['PIXEL_ASPECT_RATIO'])) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('PIXEL_ASPECT_RATIO', '${params['PIXEL_ASPECT_RATIO']}');\n";
      }
      if (!empty($params['ANALYTICS'])) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('ANALYTICS', '${params['ANALYTICS']}');\n";
      }
      if ($contextType == 2 && !empty($params['POSITIONCTL'])) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('POSITIONCTL', '${params['POSITIONCTL']}');\n";
      }
      if (!empty($params['MAX_GUI_FRAMERATE'])) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('MAX_GUI_FRAMERATE', '${params['MAX_GUI_FRAMERATE']}');\n";
      }
      if (!empty($params['EVENTID'])) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('EVENTID', '${params['EVENTID']}');\n";
      }
      if (!empty($params['NOAUDIT'])) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('NOAUDIT', '${params['NOAUDIT']}');\n";
      }

      if (isset($params['STREAMNUM'])) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('STREAMNUM', '".$params['STREAMNUM']."');\n";
      }
	  
	  if (isset($params['SKIP_GAPS'])) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('SKIP_GAPS', '".$params['SKIP_GAPS']."');\n";
      }

      if ($params['AVATARID']) {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('AVATARID', '".$params['AVATARID']."');\n";
        $appletInitTag .= "    ${internPlayerVar}.setParameter('AV_DELIVERY', '".$params['AV_DELIVERY']."');\n";
      }

      if ($initstate == 'PLAY') {
        $appletInitTag .= "    ${internPlayerVar}.setParameter('MEDIA_TRANSPORT', '${params['MEDIA_TRANSPORT']}');\n";
        if (!empty($params['MULTICAST_STREAM'])) {
          $appletInitTag .= "    ${internPlayerVar}.setParameter('MULTICAST_STREAM', '${params['MULTICAST_STREAM']}');\n";
        }
      }

      if ($initstate == 'PLAY' || $initstate == 'SNAPSHOT') {
        $bOk = $videoHelper->checkMediaCredentials($params);
        if ($bOk) {
          try {
            $videoHelper->getMediaUrl($params);
            $bOk = true;
          }
          catch (Exception $e) {
            $bOk = false;
            $errMsg = $e->getMessage();
          }
        }
        // assign media URL
        if ($bOk && $initstate == 'PLAY') {
          try {
            $videoHelper->getAuthorizationId($params);
            $bOk = true;
          }
          catch (Exception $e) {
            $bOk = false;
            $errMsg = $e->getMessage();
          }
        }

        if ($bOk) {
			if (isset($params['AVATARID'])) {
				$appletInitTag .= "    ${internPlayerVar}._mplayerRequestUrl();\n";
			}
			else {
				$url = $params['URL'];
				if (isset($params['AUTHID'])) {
					$url .= "&authorizationid=${params['AUTHID']}";
				}
				$appletInitTag .= "    ${internPlayerVar}.setParameter('URL', '$url');\n";				
			}

          if ($initstate == 'PLAY') {
            $appletInitTag .= "    ${internPlayerVar}.play(1,1);";
          }
        }
      } // end Play/Snapshot
    } // end !$bOk

    if (!$bOk) {
      // context is already set
      // process error code/message
      $errMsg = str_replace('"', '\'', $errMsg);
      $errCode ='';
      $errCodes = array();
      if (preg_match("/\x28([A-Z]{3}-[0-9]{3,})\x29/", $errMsg, $errCodes, PREG_OFFSET_CAPTURE)) {
        $errCode = $errCodes[0][0];
        $errMsg = trim(substr($errMsg, 0, $errCodes[0][1] - 1));
      }
      $appletInitTag .= "    ${internPlayerVar}.displayMessage(\"${errMsg}\",\"${errCode}\",1);\n";

        // simulate command failure to enforce reconnect on recoverable error
        if ($contextType == 2 && $initstate == 'PLAY') {
          $appletInitTag .= "    ${internPlayerVar}.command = (new Command()).play(1,1,null);\n";
          $appletInitTag .= "    ${internPlayerVar}.command.status = 3;\n";
        }
    } // end !$bOk
  }

  $playerAppletId = '_applet_player_' . $htmlObjId;
  $jitterBufferLength = Identity::getAttribute("JITTER_BUFFER_LENGTH");
  $PLAYER_BROKEN_STREAM_INDICATION = Template::boolVal(Identity::getAttribute("PLAYER_BROKEN_STREAM_INDICATION")) ? "true" : "false";
  $PLAYER_BROKEN_STREAM_INDICATION_DELAY = intval(Identity::getAttribute("PLAYER_BROKEN_STREAM_INDICATION_DELAY"));

  $codebaseUrl = '/common/activex/';
  $isDebugging = (empty($args['DEBUG']) || $args['DEBUG']!="1" && strtoupper($args['DEBUG'])!="ON") ? false : true;
  // Generate HTML code
  //
  $MediaPlayerVersion = Node::getLabel();
  return <<<EOH
<!-- Media Player, Id=${htmlObjId} -->
<script>
	var $internPlayerVar = null;
	function ${internPlayerVar}_onPlayerReady()
	{
		$internPlayerVar = new MPlayer('$htmlObjId', '$playerAppletId', $args[WIDTH], $args[HEIGHT]);
		${internPlayerVar}.defaultJitterBufferLength = ${jitterBufferLength};
		${appletInitTag}
		function DefaultListener()
		{
			this.onContextChange = function(iplayer) {};
			this.onStatusChange = function(iplayer, command, status, errorCode) {};
			this.onNewImage = function(iplayer, timestamp) {};
			this.onBufferChange = function(iplayer, startTS, endTS) {};
			this.onRPlaybackChange = function(iplayer, isEnabled) {};
			this.onClick = function(player, x, y, menuItemName, isActive)
			{
	            if(parent.mx){
					if(parent.mx.MATRIX2.getServer().getJSXById('${htmlObjId}')){
						parent.mx.MATRIX2.setSelectedGroup(parent.mx.MATRIX2.getServer().getJSXById('${htmlObjId}').getDescendantOfName('cell_select'), false, false);
					}
				}else if(parent.parent.mx){
                    //parent.parent.mx.GE.callPTZmove(player, x, y);
            	}
			}
		}
		var defaultListener = new DefaultListener();
		if (${internPlayerVar}.listener == null)
		{
			${internPlayerVar}.setListener(defaultListener);
		}
	}
	function ${internPlayerVar}_onStatusChange(status,code,message)
	{
		${internPlayerVar}._onStatusChange(status,code,message);
	}
	function ${internPlayerVar}_onNewImage(ts, tsf, bts, btsf, ets, etsf)
	{
		${internPlayerVar}._onNewImage(ts, tsf, bts, btsf, ets, etsf);
	}
	function ${internPlayerVar}_onBufferChange(bts, btsf, ets, etsf)
	{
		${internPlayerVar}._onBufferChange(bts, btsf, ets, etsf);
	}
	function ${internPlayerVar}_onImageClick(x, y, isActive)
	{
		// for matrix gui
		if (parent.mx)
		{
			if(parent.mx.MATRIX2.getServer().getJSXById('${htmlObjId}')){
				parent.mx.MATRIX2.setSelectedGroup(parent.jsx3.GO('${htmlObjId}'), false, false);
				${internPlayerVar}._onImageClick(x, y, isActive);
			}
		} else {
		// for admin gui
			${internPlayerVar}._onImageClick(x, y, isActive);
		}
	}
	function ${internPlayerVar}_onSnapshotFinish()
	{
		${internPlayerVar}._onSnapshotFinish();
	}

    embedMPlayer(${objid}, "${playerAppletId}", "${codebaseUrl}", ${args['WIDTH']}, ${args['HEIGHT']}, ${args['CACHESIZEMB']}, "${internPlayerVar}", "${MediaPlayerVersion}", "${isDebugging}", ${args['IMAGECALLBACKS']}, ${jitterBufferLength}, ${PLAYER_BROKEN_STREAM_INDICATION}, ${PLAYER_BROKEN_STREAM_INDICATION_DELAY});

</script>
<!-- End Player, Id=${htmlObjId} -->
EOH;
}
