<?php defined('APL_PATH') or die('No direct script access.');
/*
# $Id: i18n.php 30559 2014-05-07 21:34:00Z astarostin $
#------------------------------------------------------------------------------
# in this file we setup $_SESSION and $_COOKIE arrays for internationalization
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by: Sergey Tsybulsky
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
require_once APL_PATH . '/api/lib/php/gettext.php';

$locale = "en_US";
$languages = getLanguageList();
if(isset($_COOKIE["language"]) && isset($languages[$_COOKIE["language"]]))
{
	$locale = $_COOKIE["language"];
} else {
	$systemStatus = Node::getSystemStatus(true);
	if (!in_array($systemStatus["status"], array("OFFLINE", "BROKEN")))
	{
		$locale = Identity::getAttribute("SYSTEM_LANGUAGE");
	}
}
setDomainLanguage($locale, "admin");

$langDirection = "ltr";
// Check language direction and set lang_direction cookie
if (isset($languages[$locale]))
{
	$langDirection = $languages[$locale]["direction"];
}

if (php_sapi_name() != "cli" && (!isset($_COOKIE["lang_direction"]) || $_COOKIE["lang_direction"] != $langDirection))
{
	$secure = isset($_SERVER["HTTPS"]);
	setcookie("lang_direction", $langDirection, 0, "/", "", $secure);
}

function setDomainLanguage($locale, $domain)
{
	putenv("LC_MESSAGES=$locale");
	setlocale(LC_MESSAGES, "$locale");

	bindtextdomain($domain, $_SERVER['APL'] . "/conf/etc/locale");
	textdomain($domain);
	bind_textdomain_codeset($domain, 'UTF-8');
}

function getLanguageList()
{
	return array(
		"ru_RU" => array(
			"name" => "Russian",
			"direction" => "ltr"
		),
		"es_ES" => array(
			"name" => "Spanish",
			"direction" => "ltr"
		),
		"en_US" => array(
			"name" => "English",
			"direction" => "ltr"
		),
		"ar_AE" => array(
			"name" => "Arabic",
			"direction" => "rtl"
		)/*,
		"he_IL" => array(
			"name" => "Hebrew",
			"direction" => "rtl"
		)*/
	);
}
