<?php
/*
# $Id: gettext.php 27730 2013-01-20 17:57:33Z astarostin $
#------------------------------------------------------------------------------
# functions for internationalization
#------------------------------------------------------------------------------
# Author: Andrey Starostin
# Edited by:
# QA by:
# Copyright: videoNEXT Network Solutions LLC 2006
#-----------------------------------------------------------------------------
*/
// Implement gettext context
if (!function_exists('pgettext')) {
    function pgettext($context, $msgid) {
        $contextString = "{$context}\004{$msgid}";
        $translation = _($contextString);
        if ($translation == $contextString)  return $msgid;
        else  return $translation;
    }

    function npgettext($context, $msgid, $msgid_plural, $num) {
        $contextString = "{$context}\004{$msgid}";
        $contextStringp = "{$context}\004{$msgid_plural}";
        $translation = ngettext($contextString, $contextStringp, $num);
        if ($translation == $contextString ||
            $translation == $contextStringp)  return $msgid;
        else  return $translation;
    }
}

// New gettext keyword for regular strings with optional context argument
function __($message, $context ="")
{
    if($context != "")
	{
        $str = pgettext($context, $message);
    } else {
        $str = _($message);
    }
	return str_replace('"', '&quot;', $str);

}

// New gettext keyword for plural strings with optional context argument
function __n($message, $message_plural, $num, $context ="")
{
    if($context != "")
	{
        $str = npgettext($context, $message, $message_plural, $num);
    } else {
        $str = ngettext($message, $message_plural, $num);
    }
	return str_replace('"', '&quot;', $str);
}
