<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Wall.php 27611 2012-12-23 20:47:14Z astarostin $
 * ------------------------------------------------------------------------------
 * This class represents logic for Wall objects
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class Wall extends Device
{
	public function __construct()
	{
		parent::__construct("wall", "D", "W");
	}

	/**
	 * @param array $attributes
	 * @return int
	 */
	public function create(array $attributes)
	{
		$obj = parent::create($attributes);

		$uni = Node::getUNI();
		$nodeid = Node::getMasterNodeId();

		$devid = 'w' . $obj;

		DB::query("UPDATE _objs SET node_id = ?, node_ip = ? WHERE obj = ?;", array($nodeid, $uni, $obj));
		$this->setAttributes(
			$obj,
			array(
				"OBJID" => $obj,
				"DEVID" => $devid
			)
		);

		return $obj;
	}

	public function getObjects($obj, $otype = null, $subtype = null)
	{
		return array();
	}

	public function getTemplateAttributes($obj, $attributes = array())
	{
		$attrs = parent::getTemplateAttributes($obj, $attributes);
		//if new posture object
		if (isset($attributes['SCHEDULEID']) && $attributes['SCHEDULEID']!=''){
			$scheduleid = $attributes['SCHEDULEID'];
		}else{ //if posture exists
			$scheduleid = $this->getAttribute($obj, 'SCHEDULEID');
		}
		if (isset($scheduleid) && $scheduleid !== '' && $scheduleid*1 > 0){
/*		create attributes connected with layouts
		section - Schedule
		name - layout name
		type - dropmenu
		val - posture on layout
		list - postures list
		js - ?

		get layout list on wall
		get postures list
*/			if (isset($attrs['attributes']['SCHEDULE_LAYOUT'])){
				$posture = new Posture();

				$posturelist = $posture->getUnusedPosturesList($scheduleid);

				$layoutlist = DB::select("
					SELECT o.obj, o.name, o.udid FROM _objs o, _obj_attr oa
					WHERE o.otype='G' and o.subtype = 'L' and o.deleted=0
						and o.obj=oa.obj
						and oa.attr = 'WALL' AND oa.val=?
						order by o.obj;
					", array($obj));

				$postlist = array();
				$postlist[] = array('value'=>'', 'label'=>'');
				foreach($posturelist as $posture){
					$postlist[] = array('value'=>$posture['obj'], 'label'=>$posture['name']);
				}

				$categorynum = -1;
				for($i=0; $i < count($attrs['categories']); $i++){
					if ($attrs['categories'][$i]['category'] == 'Schedule'){
						$categorynum = $i;
					}
				}

				//SCHEDULE_LAYOUT format: '[{"layout":115, "posture":[120,121]}, {"layout":117, "posture":[125]}]';
				if ($categorynum >= 0){
					$SCHEDULE_LAYOUT_json = $this->getAttribute($obj, 'SCHEDULE_LAYOUT');
					$vallist = array();
					if($SCHEDULE_LAYOUT_json && $SCHEDULE_LAYOUT_json != ''){
						$SCHEDULE_LAYOUT_arr = json_decode($SCHEDULE_LAYOUT_json);
						foreach($SCHEDULE_LAYOUT_arr as $lt){
							if (isset($lt->layout) && isset($lt->posture)){
								$vallist[$lt->layout] = implode(',', $lt->posture);
							}
						}
					}

					$SCHEDULE_LAYOUT_LIST = array();
					foreach($layoutlist as $layout){
						$SCHEDULE_LAYOUT_LIST[] = $layout['obj'];
						$val='';
						if(isset($vallist[$layout['obj']])){
							$val=$vallist[$layout['obj']];
						}
						$attrs['attributes']['LAYOUT' . $layout['obj']] = array(
							"VALUE" => $val,
							"TYPE"	=> 'dropmenu',
							"LABEL"	=> __('Posture for layout')  . " " . $layout['name'],
							"LIST"	=> $postlist,
							"VALIDATE" => 'Validate.DEFAULT.LAYOUT',
							"ERROR" => ''
						);
						$attrs['categories'][$categorynum]['attributes'][] = 'LAYOUT' . $layout['obj'];
					}
					$attrs['attributes']['SCHEDULE_LAYOUT_LIST']["VALUE"] = implode(",", $SCHEDULE_LAYOUT_LIST);
				}
			}
		}
		return $attrs;
	}

	/**
	 * set object attributes
	 * @param  $obj
	 * @param  array $attributes
	 * @return void
	 */
	public function setAttributes($obj, array $attributes){

		$doFixSCHEDULE_LAYOUT = false;

		//get old SCHEDULE_LAYOUT and replace changed values
		if(isset($attributes['SCHEDULEID'])){
			$oldSCHEDULEID = $this->getAttribute($obj, 'SCHEDULEID');
			if($oldSCHEDULEID != $attributes['SCHEDULEID']) {
				$attributes['SCHEDULE_LAYOUT'] = '';
			}
		} else {
			$vallist = array();
			$SCHEDULE_LAYOUT_json = $this->getAttribute($obj, 'SCHEDULE_LAYOUT');
			if($SCHEDULE_LAYOUT_json && $SCHEDULE_LAYOUT_json != ''){
				$SCHEDULE_LAYOUT_arr = json_decode($SCHEDULE_LAYOUT_json);
				foreach($SCHEDULE_LAYOUT_arr as $lt){
					if (isset($lt->layout) && isset($lt->posture)){
						$vallist[$lt->layout] = $lt->posture . '';
					}
				}
			}

			foreach($attributes as $name=>$attribute){
				if (strpos($name, "LAYOUT")===0){
					//make SCHEDULE_LAYOUT attr from
					//get id from LAYOUTxxx
					//SCHEDULE_LAYOUT format: '[{"layout":115, "posture":["120","121"]}, {"layout":117, "posture":["125"]}]';

					$layoutid = substr($name, 6);
					if ($layoutid && $layoutid != '' && $layoutid > 0){
						$vallist[$layoutid] =  $attribute;
						$doFixSCHEDULE_LAYOUT = true;
					}
				}
			}

			$tmpArrSCHEDULE_LAYOUT = array();
			foreach($vallist as $layout=>$posture){
				if($posture && $posture != '' && $posture > 0){
					$tmpArrSCHEDULE_LAYOUT[] = array('layout'=>$layout, 'posture'=>$posture);
				}
			}

			if ($doFixSCHEDULE_LAYOUT ){
				$tmpSCHEDULE_LAYOUT = json_encode($tmpArrSCHEDULE_LAYOUT);
				if($tmpSCHEDULE_LAYOUT != '[]' && $tmpSCHEDULE_LAYOUT != ''){
					$attributes['SCHEDULE_LAYOUT'] = $tmpSCHEDULE_LAYOUT;
				} else
				if($tmpSCHEDULE_LAYOUT == '[]'){
					$attributes['SCHEDULE_LAYOUT'] = '';
				}
			}
		}
		parent::setAttributes($obj,$attributes);
	}

}
