<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: View.php 33126 2015-10-01 19:01:51Z astarostin $
 * ------------------------------------------------------------------------------
 * This class represents HTTP API for View objects
 * ------------------------------------------------------------------------------
 * @author Sergey Abaev
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

class View extends ObjectTemplate
{
	public function __construct()
	{
		$this->otype = "G";
		$this->subtype = "V";
		parent::__construct("view");
	}

	public function getList()
	{
		$userId = $_SESSION[SESSION_USERID];

		// View must belong to one of user roles
		$attr = DB::select("
			SELECT *
				FROM _obj_attr
				WHERE
					obj IN (
						SELECT _objs.obj
							FROM _objs, _obj_attr
							WHERE
								_objs.otype = 'G'
								AND _objs.subtype = 'V'
								AND _objs.deleted != 1
								AND _objs.obj = _obj_attr.obj
					)
					AND attr != 'DATA'"
		);

		$list = array();
		foreach ($attr as $row) {
			$list[$row['obj']]['obj'] = $row['obj'];
			$list[$row['obj']]['attributes'][$row['attr']] = $row['val'];
		}

		// Select all roles avaliable for current user
		$user = new User();
		$guis = $user->getGuis($userId);

		foreach ($guis as $gui) {
			// for admin role we return all views confs regardless to their roles
			if ($gui['obj'] == Obj::CONTROL_PANEL)
				return array_values($list);
		}

		$roles = $user->getRoles($userId);
		$rolesId = array();
		foreach ($roles as $role) {
			$rolesId[] = $role['obj'];
		}

		foreach ($list as $row) {
			if (!in_array($row['attributes']['ROLEID'], $rolesId)) {
				unset($list[$row['obj']]);
			}
		}

		return array_values($list);
	}
}
