<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Utils.php 33241 2015-11-01 20:32:49Z astarostin $
 * ------------------------------------------------------------------------------
 * different methods
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class Utils
{
	public function __construct()
	{}

	/**
	 * convert object to array
	 *
	 * @static
	 * @param  Object $data
	 * @return array
	 */
	public static function object_to_array($data)
	{
		if (is_array($data) || is_object($data))
		{
			$result = array();
			foreach ($data as $key => $value)
			{
				$result[$key] = self::object_to_array($value);
			}
			return $result;
		}
		return $data;
	}

	/**
	 * @param array $array
	 * @param int $level
	 * @return string
	 */
	public static function array_to_xml($array, $level = 1)
	{
		$xml = '';
		if ($level == 1)
		{
			$xml .= '<?xml version="1.0" encoding="UTF-8"?>' .
					"\n<root>\n";
		}
		foreach ($array as $key => $value)
		{
			$key = strtolower($key);
			if (is_object($value))
			{
				$value = get_object_vars($value);
			} // convert object to array

			if (is_array($value))
			{
				$multi_tags = false;
				foreach ($value as $key2 => $value2)
				{
					if (is_object($value2))
					{
						$value2 = get_object_vars($value2);
					} // convert object to array
					if (is_array($value2))
					{
						$xml .= str_repeat("\t", $level) . "<$key>\n";
						$xml .= self::array_to_xml($value2, $level + 1);
						$xml .= str_repeat("\t", $level) . "</$key>\n";
						$multi_tags = true;
					} else
					{
						if (trim($value2) != '')
						{
							if (htmlspecialchars($value2) != $value2)
							{
								$xml .= str_repeat("\t", $level) .
										"<$key2><![CDATA[$value2]]>" . // changed $key to $key2... didn't work otherwise.
										"</$key2>\n";
							} else
							{
								$xml .= str_repeat("\t", $level) .
										"<$key2>$value2</$key2>\n"; // changed $key to $key2
							}
						}
						$multi_tags = true;
					}
				}
				if (!$multi_tags and count($value) > 0)
				{
					$xml .= str_repeat("\t", $level) . "<$key>\n";
					$xml .= self::array_to_xml($value, $level + 1);
					$xml .= str_repeat("\t", $level) . "</$key>\n";
				}

			} else
			{
				if (trim($value) != '')
				{
					if (htmlspecialchars($value) != $value)
					{
						$xml .= str_repeat("\t", $level) . "<$key>" .
								"<![CDATA[$value]]></$key>\n";
					} else
					{
						$xml .= str_repeat("\t", $level) .
								"<$key>$value</$key>\n";
					}
				}
			}
		}
		if ($level == 1)
		{
			$xml .= "</root>\n";
		}
		return $xml;
	}

	/**
	 * @param array $in
	 * @param int $indent
	 * @param bool $from_array
	 * @return string
	 */
	public static function json_readable_encode($in, $indent = 0, $from_array = false)
	{
		$_escape = function ($str)
		{
			return preg_replace("!([\b\t\n\r\f\"\\'])!", "\\\\\\1", $str);
		};

		$out = '';

		foreach ($in as $key=>$value)
		{
			$out .= str_repeat("\t", $indent + 1);
			$out .= "\"".$_escape((string)$key)."\": ";

			if (is_object($value) || is_array($value))
			{
				$out .= "\n";
				$out .= self::json_readable_encode($value, $indent + 1);
			}
			elseif (is_bool($value))
			{
				$out .= $value ? 'true' : 'false';
			}
			elseif (is_null($value))
			{
				$out .= 'null';
			}
			elseif (is_string($value))
			{
				$out .= "\"" . $_escape($value) ."\"";
			}
			else
			{
				$out .= $value;
			}

			$out .= ",\n";
		}

		if (!empty($out))
		{
			$out = substr($out, 0, -2);
		}

		$out = str_repeat("\t", $indent) . "{\n" . $out;
		$out .= "\n" . str_repeat("\t", $indent) . "}";

		return $out;
	}

	/**
	 * return filtered array with specified keys, or started with specified string
	 *
	 * @param array $input
	 * @param array $keys
	 * @param string $start
	 *
	 * @return array
	 */
	public static function array_intersect_keys(array $input, array $keys = array(), $start = "")
	{
		foreach ($input as $key => &$value)
		{
			if (strpos($key, $start) !== 0
			    && !in_array($key, $keys))
			{
				unset($input[$key]);
			}
		}
		unset($value);

		return $input;
	}

}
