<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Timecard.php 29272 2013-08-05 16:42:18Z teetov $
 * ------------------------------------------------------------------------------
 * This class represents logic for Timecard
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

class Timecard extends ScheduleObject
{
	public function __construct()
	{
		$this->otype = 'T';
		$this->subtype = 'T';
		parent::__construct("timecard");
	}

	/**
	 *
	 *
	 * @param  array $attributes
	 * @param int $scheduleid
	 * @param int $postureid
	 * @return int
	 */
	public function create(array $attributes, $scheduleid = 0, $postureid=0)
	{
		$summary_attr = '';

		$DESCRIPTION = '';
		if (isset($attributes["DESCRIPTION"]) ){
			$DESCRIPTION = $attributes["DESCRIPTION"];
		}

		$ICAL_DATA = '';
		if (isset($attributes["ICAL_DATA"]) )
		{
			if(is_array($attributes["ICAL_DATA"]) || is_object($attributes["ICAL_DATA"])){
				$attributes["ICAL_DATA"] = json_encode($attributes["ICAL_DATA"]);
			}
			$ICAL_DATA = $attributes["ICAL_DATA"];
		}

		if (!isset($attributes["SUMMARY"]) || $attributes["SUMMARY"] != ''){
			$summary_attr = $this->createSummary($ICAL_DATA, $DESCRIPTION, $scheduleid);
			$attributes["SUMMARY"] = $summary_attr;
		}
		$obj = parent::create($attributes);
		if ($postureid>0 || $scheduleid>0){
			$posturename = $this->getFullName($postureid);
			$schedulename = $this->getFullName($scheduleid);
		}else{
			$schedulePosture = $this->getSchedulePosture($obj);
			$posturename = $schedulePosture['posturename'];
			$schedulename = $schedulePosture['schedulename'];
		}

		Audit::addRecordVArg(41, $obj, $_SESSION[SESSION_USERID], $schedulename, $posturename, "created", Audit::attrValueEntity('NAME', ''));
		return $obj;
	}

	public function delete($obj, $onlyMark = true, $scheduleid=0, $postureid=0)
	{
		if ($scheduleid==0 && $postureid==0){
			$schedulePosture = $this->getSchedulePosture($obj);
			$posturename = $schedulePosture['posturename'];
			$schedulename = $schedulePosture['schedulename'];
		}else{
			$posturename = $this->getFullName($postureid);
			$schedulename = $this->getFullName($scheduleid);
		}
		$result = parent::delete($obj, $onlyMark);
		if ($result){
			Audit::addRecordVArg(41, $obj, $_SESSION[SESSION_USERID], $schedulename, $posturename, "deleted");
		}
		return $result;
	}

	/**
	 * set timecard attributes
	 *
	 * @param  int $obj
	 * @param  array $attributes
	 */
	public function setAttributes($obj, array $attributes)
	{
		$oldAttrs = $this->getAttributes($obj);
		$summary_attr = '';
		if (isset($attributes["DESCRIPTION"]) ){
			$summary_attr = $attributes["DESCRIPTION"];
		}else{
			$summary_attr = $this->getAttribute($obj, "DESCRIPTION");
		}

		$schedule = $this->getSchedulePosture($obj);
		$scheduleid	= $schedule['scheduleid'];
		if (isset($attributes["ICAL_DATA"]))
		{
			$ICAL_DATA = $attributes["ICAL_DATA"];
			if (is_array($attributes["ICAL_DATA"]) || is_object($attributes["ICAL_DATA"])){
				$ICAL_DATA = json_encode($attributes["ICAL_DATA"]);
			}
			$summary_attr = $this->createSummary($ICAL_DATA, $summary_attr, $scheduleid);
		}else{
			$summary_attr = $this->createSummary($this->getAttribute($obj, "ICAL_DATA"), $summary_attr, $scheduleid);
		}

		$old_summary = $this->getAttribute($obj, "SUMMARY");
		if (!isset($attributes["SUMMARY"]) || $attributes["SUMMARY"] == '' || $old_summary == $attributes["SUMMARY"]){
			$attributes["SUMMARY"] = $summary_attr;
		}
		parent::setAttributes($obj, $attributes);
		if (isset($attributes['ICAL_DATA']))
		{
			// select schedule id
			// update stime to schedule
			$this->updateSTime($obj);
			$list = DB::select("select sl.scheduleid from schedulelink sl, _objs o where o.obj=sl.timecardid and o.deleted=0 and sl.timecardid = ?;",array($obj));
			foreach ($list as $row)
			{
				$this->updateSTime($row['scheduleid']);
			}
		}
		$auditValues = array();
		foreach ($attributes as $key => $value)
		{
			if($oldAttrs[$key] != $value){
				if ($key != 'ICAL_DATA'){
					array_push($auditValues, Audit::attrChangeEntity($key, $oldAttrs[$key], $value));
				}
			}
		}
		if (count($auditValues)>0){
			$schedulePosture = $this->getSchedulePosture($obj);
			array_push($auditValues, $schedulePosture['schedulename']);
			array_push($auditValues, $schedulePosture['posturename']);
			array_push($auditValues, "edited");
			Audit::addRecord(41, $auditValues, $obj, $_SESSION[SESSION_USERID]);
		}
	}


	public static function iCalToSymplyString($ical='')
	{
		$res = '';
		$pattern = '/DTSTART:(\d)+T(\d)+/';
		$matches = null;
		preg_match($pattern, $ical, $matches);
		return (implode(' ~ ', $matches));
		if (isset($matches[0][0])){
			$res .= $matches[0][0];
			print_r ($matches);
		}
		$pattern = '/DTEND:(\d)+T(\d)+/';
		$matches = null;
		preg_match($pattern, $ical, $matches);
		if (isset($matches[0][0])){
			$res .= $matches[0][0];
			print_r ($matches);
		}
		$pattern = '/PRULE:(.)+\h/';
		$matches = null;
		preg_match($pattern, $ical, $matches);
		if (isset($matches[0][0])){
			$res .= $matches[0][0];
			print_r ($matches);
		}
		return $res;
	}


	public function getSchedulePosture($obj)
	{
		$postureid = 0;
		$scheduleid = 0;
		$list = DB::select("SELECT distinct postureid, scheduleid FROM schedulelink where timecardid = ?;", array($obj));
		foreach ($list as $obj){
			$postureid = $obj["postureid"];
			$scheduleid = $obj["scheduleid"];
		}
		$res = array('scheduleid' => $scheduleid, 'postureid' => $postureid, 'schedulename' => $this->getFullName($scheduleid), 'posturename' => $this->getFullName($postureid));
		return $res;
	}

	public function ruleArrToICal(array $timecardinfo, $timezone='UTC')
	{
		// startTS and endTS in TimeStamp format
		//	var timecardinfo = {'startTS':tc_start, 'endTS':tc_end, 'allday':tc_allDay, 'rrule':tc_rrule, 'summary': tc_summary, 'timezone':tc_timezone};
		//	var rrule = {'interval':interval, 'frequency':frequency, 'byday':byday, 'count':count, 'until':until};

		$str = '';
		$tz = new DateTimeZone($timezone);
		$timeZoneUTC = new DateTimeZone("UTC");
		$dateUTC = new DateTime("now", $timeZoneUTC);
		$tzOffset = $tz->getOffset($dateUTC);

		if (is_array($timecardinfo) && count($timecardinfo)>0){
			$config = array( 'unique_id' => 'icaldomain.com' , "TZID" => $timezone );
			$v = new vcalendar($config); // initiate new CALENDAR
			$v->setProperty( 'X-WR-CALNAME', 'Sample calendar' );   // set some X-properties, name, content.. .
			$v->setProperty( 'X-WR-CALDESC', 'Description' );
			$v->setProperty( 'X-WR-TIMEZONE', $timezone); //TODO: GET schedule TZ, or UTC

			$e = & $v->newComponent( 'vevent' );           // initiate a new EVENT
			$dateUTC->setTimestamp($timecardinfo['startTS']);
			$tzOffsetStart = $tz->getOffset($dateUTC);					
			$e->setProperty( 'dtstart', array("timestamp"=>$timecardinfo['startTS']-$tzOffsetStart,"tz"=>$timezone));
			if (isset($timecardinfo['endTS']) && $timecardinfo['endTS'] != ''){
				$dateUTC->setTimestamp($timecardinfo['endTS']);
				$tzOffsetEnd = $tz->getOffset($dateUTC);			
				$e->setProperty( 'dtend', array("timestamp"=>$timecardinfo['endTS']-$tzOffsetEnd,"tz"=>$timezone));
			}else if (isset($timecardinfo['duration']) && $timecardinfo['duration'] != ''){
				$e->setProperty( 'duration', $timecardinfo['duration']);
			}
			if (isset($timecardinfo['summary']) && $timecardinfo['summary'] != ''){
				$e->setProperty( 'summary', $timecardinfo['summary']);
			}

			// rrule
			if (isset($timecardinfo['rrule']) && is_array($timecardinfo['rrule']) && count($timecardinfo['rrule'])>0){
				$rrule = array();
				if (isset($timecardinfo['rrule']['frequency']) && $timecardinfo['rrule']['frequency'] != ''){
					$rrule['FREQ'] = $timecardinfo['rrule']['frequency'];
					if ($timecardinfo['rrule']['frequency'] == 'WEEKLY' && isset($timecardinfo['rrule']['byday']) && count($timecardinfo['rrule']['byday'])>0){
						$byday = array();
						foreach ($timecardinfo['rrule']['byday'] as $day){
							$byday[] = array(null, "DAY" => $day);
						}
						$rrule['BYday'] = $byday;
					}
				}
				if (isset($timecardinfo['rrule']['interval']) && $timecardinfo['rrule']['interval'] != '' && $timecardinfo['rrule']['interval'] != 0){
					$rrule['INTERVAL'] = $timecardinfo['rrule']['interval'];
				}
				if (isset($timecardinfo['rrule']['count']) && $timecardinfo['rrule']['count'] != '' && $timecardinfo['rrule']['count'] != 0){
					$rrule['COUNT'] = $timecardinfo['rrule']['count'];
				}
				if (isset($timecardinfo['rrule']['until'])){
					$rrule['UNTIL'] = $timecardinfo['rrule']['until'];
				}
				$e->setProperty( 'rrule', $rrule);
			}
			if (isset($timecardinfo['exdate']) && is_array($timecardinfo['exdate']) && count($timecardinfo['exdate'])>0){
				$exdates = array();
				foreach ($timecardinfo['exdate'] as $timeStamp){
					$exdates[] = array( "timestamp" => $timeStamp-$tzOffset,"tz"=>$timezone);
				}
				$e->setProperty( 'exdate', $exdates);
			}

			$str = $v->createCalendar();                   // generate and get output in string, for testing?
		}
		return $str;
	}

	public function icaltoarray1($ical, $timezone='UTC', $datefrom = null, $dateto = null)
	{
		date_default_timezone_set('UTC');	
		if ($ical == '') return array();
		// result array for single timecard[
		//	{
		//		start: '2011-04-04'
		//		end:
		//	},
		//	{
		//		...
		//	}
		// ]

		if ($datefrom===null){
			$datefrom = new DateTime();
			$datefrom->sub(new DateInterval('P31D'));
		}
		$datefromstr = $datefrom->format('Y-m-d');

		$datefromY = $datefrom->format('Y');
		$datefromM = $datefrom->format('m');
		$datefromD = $datefrom->format('d');
		if ($dateto===null){
			$dateto = new DateTime();
			$dateto->add(new DateInterval('P31D'));
		}
		$datefromstr = $dateto->format('Y-m-d');
		$datetoY = $dateto->format('Y');
		$datetoM = $dateto->format('m');
		$datetoD = $dateto->format('d');

		$config = array( 'unique_id' => 'icaldomain.com' , "TZID" => $timezone );

		$v = new vcalendar( $config );
		$v->parse($ical);
		$v->sort();

		/*new version*/
		/* may be use foreach($v as $vevent) */
		$vevent = $v->getComponent( 1 ); //fetch first EVENT
		$rrule = $vevent->getProperty( 'rrule' );
		$exdate = $vevent->getProperty( 'exdate' );

		$tz = new DateTimeZone($timezone);
		$timeZoneUTC = new DateTimeZone("UTC");
		$dateUTC = new DateTime("now", $timeZoneUTC);
		$tzOffset = $tz->getOffset($dateUTC);
		
		
		
		
		$timecardinfoarray = array();
		if ($vevent->getProperty( 'dtstart' ) != ''){
			$timecardinfo = array();
			$timestart = $vevent->getProperty( 'dtstart' );
			
			$dtstart = new DateTime("now", $timeZoneUTC);
			$dtstart->setDate($timestart['year'], $timestart['month'], $timestart['day']);
			$dtstart->setTime($timestart['hour'], $timestart['min'], $timestart['sec']);
			$timecardinfo['start'] = $timestart;
			
			$dateUTC->setTimestamp($dtstart->format("U"));
			$tzOffsetStart = $tz->getOffset($dateUTC);					
			
			$timecardinfo['startTS'] = $dtstart->format("U")/*+$tzOffset-$tzOffsetStart*/;
			$timecardinfo['startArr'] = implode(",",$timestart);
			
			
			$timecardinfo['startSTR'] = date("Y/m/d H:i:s e", $timecardinfo['startTS']);
			$timecardinfo['first'] = true;
			$eventstart = $timecardinfo['startTS'];
			$timecardinfo['eventstartTS'] = $eventstart;

			$eventend = null;
			if ($vevent->getProperty( 'dtend' ) != ''){
				$timeend = $vevent->getProperty( 'dtend' );
				$dtend = new DateTime("now", $timeZoneUTC);
				$dtend->setDate($timeend['year'], $timeend['month'], $timeend['day']);
				$dtend->setTime($timeend['hour'], $timeend['min'], $timeend['sec']);
				$timecardinfo['end'] = $timeend;

				$dateUTC->setTimestamp($dtend->format("U"));
				$tzOffsetEnd = $tz->getOffset($dateUTC);					
			
				$timecardinfo['endTS'] = $dtend->format("U")/*+$tzOffset-$tzOffsetEnd*/;
				if ($timecardinfo['endTS'] ==  $timecardinfo['startTS']) $timecardinfo['endTS'] ++;
				$timecardinfo['endArr'] = implode(",",$timeend);

				$timecardinfo['tzOffset'] = $tzOffset;
				$timecardinfo['timezone'] = $timezone;
				$timecardinfo['endSTR'] = date("Y/m/d H:i:s e", $timecardinfo['endTS']);
				$eventend = $timecardinfo['endTS'];
				$timecardinfo['eventendTS'] = $eventend;

			}else if ($vevent->getProperty( 'duration' ) != ''){
				$timecardinfo['duration'] = $vevent->getProperty( 'duration' );
			}

			$exdateDay = array();
			if(!($exdate == '' || $exdate === null)){
				//convert to full day

				$exdateDay = array();
				foreach($exdate as $onedate){
					// 86400 = 60*60*24
					$tmpExDay = new DateTime("now", $timeZoneUTC);
					$tmpExDay->setDate($onedate['year'], $onedate['month'], $onedate['day']);
					$tmpExDay->setTime(0, 0, 0);
					$exdateDay[] = $tmpExDay->format("U");

//					$exdateDay[] = $onedate/86400;
//					$exdateDay[] = floor($onedate/86400) * 86400;
				}
				$timecardinfo['exdate']=$exdateDay;

			}

			$timecardinfoarray[] = $timecardinfo;
			if(!($rrule == '' || $rrule === null)){
				//print_r($rrule);
				$recurlist = array();
				$start = $vevent->getProperty( 'dtstart' );
				$end = $vevent->getProperty( 'dtend' );

				$startDate = $datefrom->getTimestamp();
				$endDate   = $dateto->getTimestamp();
				$startWdate = iCalUtilityFunctions::_date2timestamp( $start );
				$endWdate = iCalUtilityFunctions::_date2timestamp( $end );

				$rdurWsecs  = $endWdate - $startWdate; // compute component duration in seconds
				$workstart  = iCalUtilityFunctions::_timestamp2date(( $startDate - $rdurWsecs ), 6);
				$workend    = iCalUtilityFunctions::_timestamp2date(( $endDate + $rdurWsecs ), 6);

				$dtstart->setDate($timestart['year'], $timestart['month'], $timestart['day']);
				iCalUtilityFunctions::_recur2date( $recurlist, $rrule, $start, $workstart, $workend );

				foreach( $recurlist as $recurkey => $recurvalue ) // key=match date as timestamp
				{
					//$recurlist[$recurkey] = $rdurWsecs; // add duration in seconds
					//$recurlist[$recurkey] = date("Y/m/d - h:i:s", $recurkey);

					//$dtstart = new DateTime();

					//get date from $recurkey
					//�������� � exdate
					$dateUTC->setTimestamp($recurkey);
					$tzOffsetRecurStart = $tz->getOffset($dateUTC);					
					$dateUTC->setTimestamp($recurkey + $rdurWsecs);
					$tzOffsetRecurEnd = $tz->getOffset($dateUTC);	

					$timecardinfo = array();
					$timecardinfo['start'] = $timestart;
					$timecardinfo['startTS'] = $recurkey/*-$tzOffsetRecurStart + $tzOffset*/;
					$timecardinfo['startArr'] = date("Y,m,d,H,i,s", $recurkey);
					
					$timecardinfo['endTS'] = $recurkey/* - $tzOffsetRecurEnd + $tzOffset*/ + $rdurWsecs;
					$timecardinfo['endArr'] = date("Y,m,d,H,i,s", $recurkey + $rdurWsecs);
					
					$timecardinfo['exdate'] = $exdate;
					$timecardinfo['startSTR'] = date("Y/m/d H:i:s e", $timecardinfo['startTS']);
					$timecardinfo['endSTR'] = date("Y/m/d H:i:s e", $timecardinfo['endTS']);
					$timecardinfo['tzOffset'] = $tzOffsetRecurStart;
					$timecardinfo['timezone'] = $timezone;

					$isExDate = false;
					foreach($exdateDay as $oneExDay){
						if (($timecardinfo['startTS'] - $oneExDay)>=0 && ($timecardinfo['startTS'] - $oneExDay)< 86400){
							$isExDate = true;
						}
					}
					$timecardinfo['eventstartTS'] = $eventstart;
					$timecardinfo['eventendTS'] = $eventend;

					if(!$isExDate){
						if($timecardinfo['startTS'] == $timecardinfoarray[0]['startTS']){
							$timecardinfoarray = array_splice($timecardinfoarray, 0, 1);
						}
						$timecardinfoarray[] = $timecardinfo;
					}

				}
			}
		}
		return $timecardinfoarray;
	}

	public function icaltoarray($ical='', $timezone = 'UTC', $datefrom = 0, $dateto = 0)
	{
		date_default_timezone_set('UTC');	
		if ($ical == '') return array();
		if ($datefrom==0){
			$datefrom = new DateTime();
			$datefrom->sub(new DateInterval('P1Y'));
		}
		$datefromstr = $datefrom->format('Y-m-d');
		$datefromY = $datefrom->format('Y');
		$datefromM = $datefrom->format('m');
		$datefromD = $datefrom->format('d');
		if ($dateto==0){
			$dateto = new DateTime();
			$dateto->add(new DateInterval('P2Y'));
		}
		$datefromstr = $dateto->format('Y-m-d');
		$datetoY = $dateto->format('Y');
		$datetoM = $dateto->format('m');
		$datetoD = $dateto->format('d');

//		var timecardinfo = {'start':tc_start, 'end':tc_end, 'allday':tc_allDay, 'rrule':tc_rrule, 'summary': tc_summary, 'timezone':tc_timezone};
//		var rrule = {'interval':interval, 'frequency':frequency, 'byday':byday, 'count':count, 'until':until};
//		$config = array( 'unique_id' => 'icaldomain.com' );
		$config = array( 'unique_id' => 'icaldomain.com' , "TZID" => $timezone );
		
		// set Your unique id
		$v = new vcalendar( $config );
		// create a new calendar instance
		$v->parse($ical);
		$v->sort();
		// ensure start date order
		$eventArray = $v->selectComponents($datefromY,$datefromM,$datefromD,$datetoY,$datetoM,$datetoD,'vevent');

		$timecardinfo = array();

		$tz = new DateTimeZone($timezone);
		$timeZoneUTC = new DateTimeZone("UTC");
		$dateUTC = new DateTime("now", $timeZoneUTC);
		$tzOffset = $tz->getOffset($dateUTC);

		foreach( $eventArray as $year => $yearArray) {
			foreach( $yearArray as $month => $monthArray ) {
				foreach( $monthArray as $day => $dailyEventsArray ) {
					$vevent = $dailyEventsArray[0];
					$timecardinfo = array();
					$timestart = $vevent->getProperty( 'dtstart' );
					$dtstart = new DateTime("now", $timeZoneUTC);
					$dtstart->setDate($timestart['year'], $timestart['month'], $timestart['day']);
					$dtstart->setTime($timestart['hour'], $timestart['min'], $timestart['sec']);
					$timecardinfo['startTS'] = $dtstart->format("U");

					if ($vevent->getProperty( 'dtend' ) != ''){
						$timeend = $vevent->getProperty( 'dtend' );
						$dtend = new DateTime("now", $timeZoneUTC);
						$dtend->setDate($timeend['year'], $timeend['month'], $timeend['day']);
						$dtend->setTime($timeend['hour'], $timeend['min'], $timeend['sec']);
						$timecardinfo['endTS'] = $dtend->format("U");
					}else if ($vevent->getProperty( 'duration' ) != ''){
						$timecardinfo['duration'] = $vevent->getProperty( 'duration' );
					}
					$timecardinfo['summary'] = $vevent->getProperty( 'summary' );

					$rrule = $vevent->getProperty( 'rrule' );
					$exdate = $vevent->getProperty( 'exdate' );

					if(!($exdate == '' || $exdate === null)){
						//convert to full day

						$exdateDay = array();
						foreach($exdate as $onedate){
							// 86400 = 60*60*24
							$tmpExDay = new DateTime();
							$tmpExDay->setDate($onedate['year'], $onedate['month'], $onedate['day']);
							$tmpExDay->setTime(0, 0, 0);
							$exdateDay[] = $tmpExDay->format("U");

		//					$exdateDay[] = $onedate/86400;
		//					$exdateDay[] = floor($onedate/86400) * 86400;
						}
						$timecardinfo['exdate']=$exdateDay;

					}

					$timecardinfo['rrule'] = array();
					if (isset($rrule['FREQ']) && $rrule['FREQ'] != '' ){
						$timecardinfo['rrule']['frequency'] = $rrule['FREQ'];
					}
					if (isset($rrule['INTERVAL']) && $rrule['INTERVAL'] != '' && $rrule['INTERVAL'] != 0){
						$timecardinfo['rrule']['interval'] = $rrule['INTERVAL'];
					}
					if (isset($rrule['BYDAY']) && is_array($rrule['BYDAY']) && count($rrule['BYDAY'])>0){
						$byday = array();
						foreach ($rrule['BYDAY'] as $dayarr){
							$byday[] = $dayarr['DAY'];
						}
						$timecardinfo['rrule']['byday'] = $byday;
					}
					if (isset($rrule['COUNT']) && $rrule['COUNT'] != '' && $rrule['COUNT'] != 0){
						$timecardinfo['rrule']['count'] = $rrule['COUNT'] ;
					}
					if (isset($rrule['UNTIL']) && $rrule['UNTIL'] != '' && $rrule['UNTIL'] != 0){
						$timecardinfo['rrule']['until'] = $rrule['UNTIL'] ;
							$untilDate = new DateTime();
							$untilDate->setDate($rrule['UNTIL']['year'], $rrule['UNTIL']['month'], $rrule['UNTIL']['day']);
							$untilDate->setTime(0, 0, 0);
							$timecardinfo['rrule']['untilTS'] = $untilDate->format("U");
					}

					$timecardinfo['tzOffset'] = $tzOffset;
					$timecardinfo['timezone'] = $timezone;
					return $timecardinfo;
				}
			}
		}
		return $timecardinfo;
	}

	public static function getTimezoneOffset($timezone = 'UTC')
	{
		$timeOffset = 0;
		$utcDateTimeZone = new DateTimeZone("UTC");
		$utcDateTime = new DateTime("now", $utcDateTimeZone);

		$currentDateTimeZone = new DateTimeZone($timezone);
		if ($currentDateTimeZone)
		{
			$timeOffset = $currentDateTimeZone->getOffset($utcDateTime);
		}
		return $timeOffset;
	}

	public function createSUMMARY($ICAL_DATA_attr, $DESCRIPTION_attr = '',$scheduleid = 0)
	{
		$ret = $DESCRIPTION_attr;

		//get schedule timezone
		$timezone = 'UTC';
		if ($scheduleid>0){
			$schedule = new Schedule();
			$timezone = $schedule->getAttribute($scheduleid, 'TIME_ZONE');
		}
		$ICAL_DATA = $this->icaltoarray($ICAL_DATA_attr, $timezone);

		$dateFormat = Template::convertStrDateFormatToPHPDateFormat(Identity::getAttribute("NLS_LONG_DATE_FORMAT"));
		if (!isset($ICAL_DATA['rrule']) || count($ICAL_DATA['rrule'])==0){
			$tmp = date($dateFormat, $ICAL_DATA['startTS']) . ", " . date("H:i", $ICAL_DATA['startTS']) . "-" . date("H:i", $ICAL_DATA['endTS']);
		}else{
			$tmp = json_encode($ICAL_DATA);
			if (isset($ICAL_DATA['rrule']['frequency'])){
				switch ($ICAL_DATA['rrule']['frequency'])
				{
					case "DAILY":
						$tmp = 'Daily';
						if (isset($ICAL_DATA['rrule']['interval']) && $ICAL_DATA['rrule']['interval'] > 1){
							$tmp = "Every " . $ICAL_DATA['rrule']['interval'] . " days";
						}
						break;
					case "WEEKLY":
						$tmp = 'Weekly';
						$byDay = '';
						if (isset($ICAL_DATA['rrule']['byday'])){
							$byDayArr = array();
							for ($i=0; $i<count($ICAL_DATA['rrule']['byday']); $i++){
								$byDayArr[$ICAL_DATA['rrule']['byday'][$i]] = $ICAL_DATA['rrule']['byday'][$i];
							}
							if(isset($byDayArr['SA']) && isset($byDayArr['SU']) && isset($byDayArr['MO'])
								 && isset($byDayArr['TU']) && isset($byDayArr['WE']) && isset($byDayArr['TH'])
								 && isset($byDayArr['FR'])
							){
								$byDay = ", on all days";
							}else
							if(isset($byDayArr['SA']) && isset($byDayArr['SU']) && !isset($byDayArr['MO'])
								 && !isset($byDayArr['TU']) && !isset($byDayArr['WE']) && !isset($byDayArr['TH'])
								 && !isset($byDayArr['FR'])
							){
								$byDay = ", on weekends";
							}else
							if(isset($byDayArr['MO'])
								 && isset($byDayArr['TU']) && isset($byDayArr['WE']) && isset($byDayArr['TH'])
								 && isset($byDayArr['FR']) && !isset($byDayArr['SA']) && !isset($byDayArr['SU'])
							){
								$byDay = ", on weekdays";
							}else{
								$dayArr = array();
								$byDay = '';
								if(isset($byDayArr['SU'])) $dayArr[] = "Sunday";
								if(isset($byDayArr['MO'])) $dayArr[] = "Monday";
								if(isset($byDayArr['TU'])) $dayArr[] = "Tuesday";
								if(isset($byDayArr['WE'])) $dayArr[] = "Wednesday";
								if(isset($byDayArr['TH'])) $dayArr[] = "Thursday";
								if(isset($byDayArr['FR'])) $dayArr[] = "Friday";
								if(isset($byDayArr['SA'])) $dayArr[] = "Saturday";
								$byDay = implode($dayArr, '');
								if($byDay != '') $byDay = ", on " . $byDay;
							}

						}
						if (isset($ICAL_DATA['rrule']['interval']) && $ICAL_DATA['rrule']['interval'] > 1){
							$tmp = "Every " . $ICAL_DATA['rrule']['interval'] . " weeks";
						}
						$tmp = $tmp . $byDay;
						break;
					case "MONHTLY":
						$tmp = 'Monthly';
						if (isset($ICAL_DATA['rrule']['interval']) && $ICAL_DATA['rrule']['interval'] > 1){
							$tmp = "Every " . $ICAL_DATA['rrule']['interval'] . " months";
						}
						break;
					default:
				}
			}
			if (isset($ICAL_DATA['rrule']['count'])){
				$tmp = $tmp . ", " . $ICAL_DATA['rrule']['count'] .  " times";
			}
			if (isset($ICAL_DATA['rrule']['untilTS'])){
				$tmp = $tmp . ", until " . date($dateFormat, $ICAL_DATA['rrule']['untilTS']);
			}
			$tmp = $tmp . ", " . date("H:i", $ICAL_DATA['startTS']) . "-" . date("H:i", $ICAL_DATA['endTS']);
		}

		if ($ret !== '') $ret = $tmp . ", " . $ret;
		else $ret = $tmp;
		//$ret = $ICAL_DATA['rrule'];
		return $ret;
	}

}
