<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Set.php 31913 2015-03-13 03:01:48Z astarostin $
 * ------------------------------------------------------------------------------
 * This class represents logic for Set
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

class Set extends CredentialContainer
{
	/**
	 * predefined set obj id's from DB
	 */
	const MOBILE_CAMERAS = 17;

	public function __construct()
	{
		$this->otype = 'S';
		$this->subtype = '*';
		parent::__construct("set");
	}

	/**
	 * @param array $attributes
	 * @return int
	 * @param  int|null $parentObj not used
	 * @throws InvalidArgumentException
	 */
	public function create(array $attributes, $parentObj = null)
	{
		// check for NAME uniqueness
		if (isset($attributes["NAME"]))
		{
			$value = $attributes["NAME"];
			$checkObj = $this->checkUniqueness(null, "NAME", $value);
			if (isset($checkObj))
			{
				throw new InvalidArgumentException(sprintf("set with obj=%s and name=%s already exists", $checkObj, $value));
			}
		}

		return parent::create($attributes);
	}

	/**
	 * set set attributes
	 *
	 * @param  int   $obj
	 * @param  array $attributes
	 * @throws InvalidArgumentException
	 */
	public function setAttributes($obj, array $attributes)
	{
		if ($this->isProtected($obj))
			throw new InvalidArgumentException(sprintf("role with obj=%s is protected", $obj));

		// check for NAME uniqueness
		if (isset($attributes["NAME"]))
		{
			$checkObj = $this->checkUniqueness($obj, "NAME", $attributes["NAME"]);
			if (isset($checkObj))
			{
				throw new InvalidArgumentException(sprintf("set with obj=%s and name=%s already exists", $checkObj, $attributes["NAME"]));
			}
		}

		parent::setAttributes($obj, $attributes);
	}

	/**
	 * select devices from set, without credentials with specified otype and subtype
	 *
	 * @param  int         $setid
	 * @param  string|null $otype
	 * @param  string|null $subtype
	 * @throws InvalidArgumentException
	 * @return array
	 */
	public function getObjects($setid, $otype = null, $subtype = null)
	{
		if (!isset($setid))
		{
			throw new InvalidArgumentException("Some parameters are missing.");
		}

		$list = DB::select("SELECT * FROM getObjectsFromSet(?, ?, ?);", array($setid, $otype, $subtype));
		return $list;
	}

	/**
	 * select roles in which set is presented
	 * @throws InvalidArgumentException
	 * @param  $setid
	 * @param  bool $withAttributes return with attributes
	 * @return array
	 */
	public function getRoles($setid, $withAttributes = false)
	{
		if (!isset($setid))
		{
			throw new InvalidArgumentException("Some parameters are missing.");
		}

		$list = DB::select("SELECT * FROM getRolesForSet(?);", array($setid));

		if ($withAttributes)
		{
			foreach ($list as &$row)
			{
				$row["attributes"] = $this->getAttributes($row["obj"]);
			}
		}

		return $list;
	}
}
