<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: ScheduleObject.php 32342 2015-05-01 21:45:23Z jenkins $
 * ------------------------------------------------------------------------------
 * specific logic for schedule objects
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

class ScheduleObject extends ObjectTemplate
{

	public function __construct($type)
	{
		parent::__construct($type);
	}

	/**
	 * get object name with UDID or ID
	 * @param  $obj
	 * @return string
	 */
	public function getFullName($obj)
	{
		$fullname = '';
		$udid = '';
		$queryString = "SELECT name, udid FROM _objs WHERE obj = ? AND deleted = 0;";
		$list = DB::select($queryString, array($obj));
		if (count($list) > 0){
			$this->name[$obj] = $list[0]['name'];
			$fullname = $list[0]['name'];
			if (isset($list[0]['udid']) && $list[0]['udid'] != ''){
				$udid = '[' . $list[0]['udid'] . '] ';
			}else{
				$udid = '#' . $obj . ' ';
			}
		}
		return $udid . $fullname;
	}
}
