<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Relay.php 27856 2013-02-07 10:09:49Z stsibulskiy $
 * ------------------------------------------------------------------------------
 * description
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */
 
class Relay extends ExternalObject 
{
	public function __construct()
	{
		parent::__construct("relay", "D", "R");
	}

	/**
	 * @param array $attributes
	 * @return int|null
	 */
	public function create(array $attributes)
	{
		$obj = null;
		//return $attributes;
		if ($this->checkNoConflicts(null, $attributes)){
			$obj = parent::create($attributes);
		}
		return $obj;
	}
	
	public function setAttributes($obj, array $attributes)
	{
		if ($this->checkNoConflicts($obj, $attributes)){
			parent::setAttributes($obj, $attributes);
		}
	}

	private function checkNoConflicts($obj=null, $attributes){
		//get node
		$node_id = '';
		$without_obj = '';

		if (isset($obj) && (int)$obj > 0) $without_obj = " and _objs.obj <> " . (int)$obj;
		if (isset($attributes['NODE_ID']) && (int)$attributes['NODE_ID'] > 0) $node_id = " and _objs.node_id = " . (int)$attributes['NODE_ID'];

		if (isset($attributes['NODE_ID']) && isset($attributes['HW_UNIT_ID']) && isset($attributes['HW_ID'])){
			$HW_UNIT_ID = (int)$attributes['HW_UNIT_ID'];
			$HW_ID = (int)$attributes['HW_ID'];

			$query = "
				SELECT _objs.obj, _objs.description, a1.val
				FROM _objs, _obj_attr a1, _obj_attr a2
				WHERE
					_objs.otype = 'D' AND _objs.subtype = ?
					AND _objs.obj = a1.obj AND a1.attr = 'HW_UNIT_ID' AND a1.val = ?
					AND _objs.obj = a2.obj AND a2.attr = 'HW_ID' AND a2.val = ?
					$without_obj $node_id AND _objs.deleted = 0;";
			$list = DB::select($query, array($this->subtype, $HW_UNIT_ID, $HW_ID));
			foreach($list as $item)
			{
				throw new InvalidArgumentException(sprintf(__("  Parent, MODBUS Unit ID or Sensor/Relay ID of device: [%d] %s has conflict with current device."), $item['obj'], $item['description']));
			}
		}
		return true;
	}

}