<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Purifier.php 26714 2012-09-05 14:52:33Z teetov $
 * ------------------------------------------------------------------------------
 * html purifier
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

include(APL_PATH . "/api/lib/php/classes/3rdParty/htmlpurifier/HTMLPurifier.auto.php");

class Purifier
{
	/**
	 * @var HTMLPurifier|null
	 */
	private static $purifier = null;

	/**
	 * @var HTMLPurifier_Config|null
	 */
	private static $config = null;

	/**
	 * clean dirty text
	 *
	 * @static
	 * @param string $dirty
	 * @return string
	 */
	public static function clean($dirty)
	{
		if (!isset(self::$purifier))
		{
			self::$config = HTMLPurifier_Config::createDefault();
			self::$config->set('Cache.DefinitionImpl', null); // TODO: remove this later!

			self::$purifier = new HTMLPurifier(self::$config);
		}

		return self::$purifier->purify($dirty);
	}
}
