<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Posture.php 31357 2014-10-13 11:42:07Z atsybulnik $
 * ------------------------------------------------------------------------------
 * This class represents logic for Set
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

class Posture extends ScheduleObject
{
	public function __construct()
	{
		$this->otype = 'T';
		$this->subtype = 'P';
		parent::__construct("posture");
	}

	/**
	 * @param array $attributes
	 * @param null $scheduleid
	 * @return int
	 */
	public function create(array $attributes, $scheduleid=null)
	{
		$obj = parent::create($attributes);

		if (!isset($attributes['PRIORITY']))
		{
			$scheduleid = $this->getAttribute($obj, 'SCHEDULE');
			$priority = 2;
			if (isset($scheduleid) and $scheduleid>0){
				$query = "
					SELECT max(oa1.val::integer) as maxprio
					FROM _objs o, _obj_attr oa, _obj_attr oa1
					WHERE oa.obj=o.obj
					and oa1.obj=o.obj
					AND (oa1.val <> '' AND NOT(oa1.val IS NULL))
					AND o.otype='T' AND o.subtype='P'
					AND oa.attr='SCHEDULE' AND oa.val = ?
					AND oa1.attr = 'PRIORITY'
					AND o.deleted = 0;";
				$list = DB::select($query, array($scheduleid));
				if (isset($list[0]['maxprio']) && trim($list[0]['maxprio'])!='') $priority = $list[0]['maxprio']+1;
			}

			$this->setAttributes($obj, array('PRIORITY' => $priority));
		}
		$auditValues = array();
		$tscheduleid = 0;
		if (isset($scheduleid) and $scheduleid>0){
			array_push($auditValues, Audit::attrValueEntity('SCHEDULE', $scheduleid));
			$tscheduleid = $scheduleid;
		}
		array_push($auditValues, $this->getFullName($tscheduleid));
		array_push($auditValues, "created");

		Audit::addRecord(42, $auditValues, $obj, $_SESSION[SESSION_USERID]);
		return $obj;
	}

	public function delete($obj, $onlyMark = true)
	{
		if (!isset($obj))
		{
			throw new InvalidArgumentException("Some parameters are missing.");
		}

		//delete Timecards
		$schedule = new Schedule();
		$timecard = new Timecard();
		$scheduleid = 0;
		$list = DB::select("select timecardid, scheduleid from schedulelink where postureid = ?;",array($obj));
		foreach ($list as $row){
			$timecard->delete($row['timecardid'], $onlyMark);
			$schedule->updateSTime($row['timecardid']);
			$scheduleid = $row['scheduleid'];
		}

		$number = DB::query("delete from schedulelink where postureid = ?;",array($obj));
		$schedulename = $this->getFullName($scheduleid);
		$result = parent::delete($obj, $onlyMark);
		$schedule->updateSTime($scheduleid);
		Audit::addRecordVArg(42, $obj, $_SESSION[SESSION_USERID], $schedulename, "deleted");
		return $result;
	}

	public function getTemplateAttributes($obj, $attributes = array())
	{
		$attrs = parent::getTemplateAttributes($obj, $attributes);
		//if new posture object
		if (isset($attributes['SCHEDULE']) && $attributes['SCHEDULE']!=''){
			$scheduleid = $attributes['SCHEDULE'];
		}else{ //if posture exists
			$scheduleid = $this->getAttribute($obj, 'SCHEDULE');
		}
		if (isset($scheduleid) && $scheduleid !== '' && $scheduleid*1 > 0){
			$shedule = new Schedule();
			$defpostattrs = $shedule->getAttributes($scheduleid);
			//	if $attrs[attr] not in defpostattr set $attrs[attr] as hidden
			foreach($attrs['attributes'] as $name=>&$attribute){
				if (strpos($name, "PROPERTY_")===0){
					if (!isset($defpostattrs[$name]) || (isset($defpostattrs[$name]) && $defpostattrs[$name]=='')){
						if (isset($attribute['TYPE'])) $attribute['TYPE'] = 'hidden';
					}
				}
			}
		}

		///////////////////////////////////////////////////////
		//create json for view pendant analitics rules on posture
		// get devices on current schedule
		// get and parce attributes ANALYTICS_SCHEDULER and ANALYTICS_SCHEDULER
		// create json for viewing
		//
		//example of created json
		//"{"119":{"udid":"[DC119]","name":"Axis 207","rules":["Rule 0","Rule 2"]}}"
		///////////////////////////////////////////////////////
		if (isset($attrs['attributes']['VAE_POSTURE_INFO'])){

			$schedule = new Schedule();
			$devicelist = $schedule->getObjectOnScheduleList($scheduleid);
			$retlist = array();
			foreach ($devicelist as $device){
				$devid = $device["obj"];
				$object = new Obj();
				$dev_attrs = $object->getAttributes($devid);
				$vae_rules = array();

				$VAEList = Node::getVAEList();
				foreach($VAEList as $vae_key=>$vae_path){
					$rules = array();
					$VAE_NAME = strtoupper($vae_key);
					if (isset($dev_attrs["VAE_${VAE_NAME}_SCHEDULER"]) && isset($dev_attrs["VAE_${VAE_NAME}_CONFIG"])
						&& $dev_attrs["VAE_${VAE_NAME}_CONFIG"] != '' && $dev_attrs["VAE_${VAE_NAME}_CONFIG"] != ''
					){
						$ANALYTICS_SCHEDULER = json_decode($dev_attrs["VAE_${VAE_NAME}_SCHEDULER"]);
						$ANALYTICS_CFG = json_decode($dev_attrs["VAE_${VAE_NAME}_CONFIG"]);

						if(is_array($ANALYTICS_SCHEDULER) && is_object($ANALYTICS_CFG) && isset($ANALYTICS_CFG->root->zone_set) && is_array($ANALYTICS_CFG->root->zone_set)){
							$i=0;
							foreach ($ANALYTICS_SCHEDULER as $zone){
								if(isset($zone->postures) && count($zone->postures)>0){
									foreach ($zone->postures as $posturesarr){
										if($posturesarr == $obj){
											$j = 0;
											foreach ($ANALYTICS_CFG->root->zone_set as $one_zone){
												if ($j == $i){
													$rules[] = $one_zone->name;
												}
												$j++;
											}
										}
									}
								}
								$i++;
							}
						}
					}
					if (count($rules)>0){
						$vae_rules[] = array('name'=>$VAE_NAME, 'rules'=>$rules);
					}
				}
				if (count($vae_rules)>0){
					$retlist[$devid] = array('udid'=>'[' . $device["udid"] . ']', 'name'=>$device["name"], 'vae'=>$vae_rules);
				}
			}
			$analitics_info = json_encode($retlist);
			$attrs['attributes']['VAE_POSTURE_INFO']['VALUE'] = $analitics_info;
		}
		return $attrs;
	}

	public function getTemplateProperty($obj = null)
	{
		$attrs = parent::getTemplateAttributes($obj);
		$postureattrs = array('attributes' => array(), 'attributeslist' => array());
		foreach($attrs['attributes'] as $name=>$attribute){
			if (strpos($name, "PROPERTY_")===0){
				$postureattrs['attributes'][$name] = $attribute;
				$postureattrs['attributeslist'][] = $name;
			}
		}
		return $postureattrs;
	}

	/**
	 * set object attributes
	 * @param  $obj
	 * @param  array $attributes
	 * @return void
	 */
	public function setAttributes($obj, array $attributes){
		$oldAttrs = $this->getAttributes($obj);
		parent::setAttributes($obj,$attributes);
		$doFixSTime = false;
		foreach($attributes as $name=>$attribute){
			if (strpos($name, "PROPERTY_")===0){
				$doFixSTime = true;
			}
		}

		$scheduleid = 0;
		$list = DB::select("select sl.scheduleid from schedulelink sl, _objs o where o.obj=sl.postureid and o.deleted=0 and sl.postureid = ?;",array($obj));
		foreach ($list as $row){
			$scheduleid = $row['scheduleid'];
			if ($doFixSTime){
				$this->updateSTime($row['scheduleid']);
			}
		}
		// if defoulf posture delete empty attributese in other postures
		$attr = $this->getAttributes($obj);
		if (isset($attr['DEFAULTFOR']) && $attr['DEFAULTFOR']!='' && $attr['DEFAULTFOR']>0){
			$scheduleid = $attr['DEFAULTFOR'];
			$emptyAttrs = array();
			foreach($attr as $name=>$value){
				if (strpos($name, "PROPERTY_")===0 && $value == ''){
					$emptyAttrs[$name] = $value;
				}
			}
			$list = DB::select("select o.obj from _obj_attr oa, _objs o where o.obj=oa.obj and o.deleted=0 and oa.attr='SCHEDULE' and oa.val = ? and o.obj not in (select obj from _obj_attr where attr='DEFAULTFOR' and val<>'');",array($scheduleid));
			foreach ($list as $row){
				$this->setAttributes($row['obj'], $emptyAttrs);
			}
		}

		$auditValues = array();
		foreach ($attributes as $key => $value)
		{
			if($oldAttrs[$key] != $value)
				array_push($auditValues, Audit::attrChangeEntity($key, $oldAttrs[$key], $value));
		}

		array_push($auditValues, $this->getFullName($scheduleid));
		array_push($auditValues, "edited");
		Audit::addRecord(42, $auditValues, $obj, $_SESSION[SESSION_USERID]);
	}

	/**
	 * get posture prroperties
	 *
	 * @param  int $postureid
	 * @return array
	 */
	public function getProperties($postureid)
	{
		$attrs = $this->getAttributes($postureid);
		$props = array();
		foreach ($attrs as $name => $value)
		{
			if (strpos($name, "PROPERTY_") === 0 && trim($value) != '')
			{
				$propertyname = substr($name, 9);
				$props[$propertyname] = $value;
			}
		}

		return $props;
	}

	/**
	 * get list of attributes assigned to property
	 *
	 * @param  string $property
	 * @return array
	 */
	public function getAttributesAssignedToProperty($property)
	{
		$attributes = array();

		// TODO: read list of attributes from posture.cfg
		array_push($attributes, $property);

		return $attributes;
	}

	/**
	 * @param  int $scheduleid
	 * @return array
	 */
	function getUnusedPosturesList($scheduleid){
		$list = array();
		if (intval($scheduleid)>1){
			$list = DB::select("
				SELECT o.*, oa.* FROM _objs o, _obj_attr oa, _obj_attr oa1
				WHERE o.otype='T' and o.subtype = 'P' and o.deleted=0
					and o.obj=oa.obj
					and o.obj=oa1.obj
					and oa.attr = 'SCHEDULE' AND oa.val=?
					and oa1.attr = 'PRIORITY'
					and o.obj not in (select obj from _obj_attr where attr='DEFAULT_POSTUREID' and val = ?)
					order by oa1.val::integer ASC;
				", array($scheduleid, $scheduleid));

			$def_list = DB::select("
				SELECT o.*, oa.*, 'true' AS \"DEFAULT\" FROM _objs o, _obj_attr oa
				WHERE o.otype='T' and o.subtype = 'P' and o.deleted=0
					and o.obj=oa.obj
					and oa.attr = 'DEFAULTFOR' AND oa.val=?
				", array($scheduleid));

			if (isset($def_list) && isset($def_list[0]) ){
				array_unshift($list, $def_list[0]);
			}
		}
		return $list;
	}

	/**
	 * gets attributes of posture and attributes of timecards on posture
	 * @param  int $postureid
	 * @return array
	 */
	public function getPostureInfo($postureid, $actualOnly = false)
	{
/*		$object = Factory::getByObj($obj);
		if (!isset($object))
			throw new InvalidArgumentException(sprintf("unknown object=%s", $obj));
*/
		$postureinfo = $this->getAttributes($postureid);
		$timecardlist = DB::select("SELECT sl.timecardid FROM schedulelink as sl, _objs as o where sl.postureid = ? and o.obj=sl.timecardid and o.deleted=0;", array($postureid));
		$timecard = new Timecard();
		$postureinfo['timecards'] = array();
		foreach ($timecardlist as $timecardid){
			$timecardinfo = $timecard->getAttributes($timecardid['timecardid']);
			$ical_arr = $timecard->icaltoarray1($timecardinfo['ICAL_DATA']);
			$ical_arr = array_shift($ical_arr);
			$timecardinfo['ICAL'] = print_r($ical_arr, true);
			unset($timecardinfo['ICAL_DATA']);
			if(!($ical_arr['endTS'] > time()) && $actualOnly)
				continue;
			$postureinfo['timecards'][$timecardid['timecardid']] = $timecardinfo;
		}
		return $postureinfo;
	}
}
