<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Polling.php 32342 2015-05-01 21:45:23Z jenkins $
 * ------------------------------------------------------------------------------
 * description
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */
class Polling
{
	/**
	 * event handler
	 * @var array
	 */
	protected $_handlers = array();

	/**
	 * create new event
	 *
	 * @param string $event event name
	 * @param array $data parameters
	 */
	public function push($event, $data = null)
	{
		/**
		 * first 8 bytes consist length of data
		 * array('evant_name1' => event_time, ..., '_updated' => event_time)
		 * event_time - time of last event
		 * _updated - time of last event
		 */
		$shmid = shmop_open(ftok(__FILE__, 'e'), 'c', 0644, 256000);
		if ($shmid)
		{
			$storageLength = (int)shmop_read($shmid, 0, 8);
			$storage = array();
			if ($storageLength)
			{
				$storage = unserialize(strval(shmop_read($shmid, 8, (int)$storageLength)));
			}
			$storage[$event] = array('time' => time(), 'data' => $data);
			$storage['_updated'] = time();
			$storageLength = strlen(serialize($storage));
			shmop_write($shmid, (int)$storageLength, 0);
			shmop_write($shmid, serialize($storage), 8);
			shmop_close($shmid);
		}
	}

	/**
	 * wait for new events
	 *
	 * @param int $lastQueryTime last wait
	 * @return array result
	 */
	public function listen($lastQueryTime = null)
	{
		$result = array();

		$lastQueryTime = ($lastQueryTime) ? : time();
		$endTime = time() + 20 - 1;

		$shmid = shmop_open(ftok(__FILE__, 'e'), 'a', 0, 0);
		if (!$shmid)
			return $result;

		while (time() < $endTime)
		{
			sleep(1);
			$storageLength = (int)shmop_read($shmid, 0, 8);
			$storage = unserialize(strval(shmop_read($shmid, 8, (int)$storageLength)));
			if ($storage['_updated'] > $lastQueryTime)
			{
				unset($storage['_updated']);
				asort($storage);

				foreach ($storage as $event => $data)
				{
					if (substr($event, 0, 1) != '_' && $data['time'] > $lastQueryTime)
					{
						$ret = $this->_runHandler($event, $data['data']);
						if ($ret)
						{
							$result[$event] = $ret;
						}
					}
				}

				break;
			}
		}
		shmop_close($shmid);

		return $result;
	}

	/**
	 * register event and attach handler to it
	 *
	 * @param string $event event name
	 * @param callback $callback callback function
	 */
	public function registerEvent($event, $callback)
	{
		$this->_handlers[$event] = $callback;
	}

	/**
	 *
	 * @param string $key event name
	 * @param array $data parameters
	 * @return mixed
	 */
	protected function _runHandler($key, $data = array())
	{
		$result = null;

		if (!empty($this->_handlers[$key]))
		{
			$result = call_user_func_array($this->_handlers[$key], array($data));
		}

		return $result;
	}
}
