<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: ObjectTemplate.php 33243 2015-11-01 23:59:59Z astarostin $
 * ------------------------------------------------------------------------------
 * Basic class for all abject in the system with template
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class ObjectTemplate extends Obj
{
	/**
	 * @var Template $template
	 */
	protected $template = null;

	public function __construct($type)
	{
		$this->type = $type;
	}

	public function getTemplate()
	{
		if (!isset($this->template))
		{
			$this->template = new Template($this->type);
		}

		return $this->template;
	}

	/**
	 * create object based on attributes and default values from template,
	 * default attributes values also can be specified by $attributes parameter
	 * @param  array $attributes
	 * @param  int|null $parentObj not used
	 * @return int
	 */
	public function create(array $attributes, $parentObj = null)
	{
		$templateAttributes = $this->getTemplate()->getDefaultAttributes();

		if (isset($templateAttributes["TIME_ZONE"]))
		{
			$templateAttributes["TIME_ZONE"] = Identity::getAttribute("TIME_ZONE");
		}

		foreach ($templateAttributes as $templateAttribute => $templateValue)
		{
			if (isset($attributes[$templateAttribute]))
			{
				$templateAttributes[$templateAttribute] = $attributes[$templateAttribute];
			}
		}

		// set object default time zone from Identity, if it not set
		return parent::create($templateAttributes);
	}

	/**
	 * return attributes description from template
	 * @param  $obj
	 * @param  array $attributes
	 * @return array
	 */
	public function getTemplateAttributes($obj = null, array $attributes = array())
	{
		$list = null;
		$isDefaultAttributes = false;

		// get values from DB
		if (isset($obj))
			$attributes = $this->getAttributes($obj);

		if (isset($attributes))
		{
			$objectModel = isset($attributes["CAMERAMODEL"]) ? $attributes["CAMERAMODEL"] : "default";
			$modelid =  isset($attributes["MODELID"]) ? $attributes["MODELID"] : "";
			$devid = isset($attributes["DEVID"]) ? $attributes["DEVID"] : $obj;
			$nodeid = $this->getUNI($obj);

			$defaultAttributes = array();
			if (!$isDefaultAttributes)
				$defaultAttributes = $attributes;

			$templateAttributes = $this->getTemplate()->getTemplateAttributes($objectModel, $modelid, $devid, $nodeid, $defaultAttributes);

			$template = array();
			$template["categories"] = array();
			$template["attributes"] = array();

			foreach ($templateAttributes as $category => $category_content)
			{
				$template["categories"][] = array("category" => $category, "attributes" => array());

				$categoriesLength = count($template["categories"]);

				foreach ($category_content["ATTR"] as $attribute => $attribute_template)
				{
					// get values from DB
					if (!$isDefaultAttributes && isset($attributes[$attribute]))
						$attribute_template['VALUE'] = $attributes[$attribute];

					$template["categories"][$categoriesLength - 1]["attributes"][] = $attribute;
					$template["attributes"][$attribute] = $attribute_template;

					unset($template["attributes"][$attribute]['ORDER']);
				}
			}

			if (!isset($obj) && isset($template["attributes"]["TIME_ZONE"]))
			{
				$template["attributes"]["TIME_ZONE"]['VALUE'] = Identity::getAttribute("TIME_ZONE");
			}

			$list = $template;
		}

		return $list;
	}

	/**
	 * sync attributes with template
	 * @param  int $obj
	 * @param  array $newAttributesList
	 * @return array do
	 */
	public function syncAttributesWithTemplate($obj, array $newAttributesList)
	{
		$do = parent::syncAttributesWithTemplate($obj, $newAttributesList);
		if ($obj == 53 && isset($do["create"][$obj]["NAME"]))
		{
			$this->setAttributes($obj, array("NAME" => Node::getHostName()));
		}

		return $do;
	}

	/**
	 * get object type
	 * @param  $obj
	 * @return string object type
	 */
	public function getType($obj = null)
	{
		$type = null;

		if (isset($obj))
		{
			$type = parent::getType($obj);
		} else {
			$this->type;
		}

		return $type;
	}
}
