<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: ObjectManager.php 28462 2013-04-24 12:54:56Z astarostin $
 * ------------------------------------------------------------------------------
 * Temporary class for storing information about changed objects for sending to ObjectManager.
 *
 * For sending changes, add them by calling setAttribute, delete and then call send function
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2012
 * ------------------------------------------------------------------------------
 */

// TODO: remove need of sending notofication about changes to ObjectManager

class ObjectManager
{
	/**
	 * @var array
	 */
	protected static $modifiedObjects = array("edit" => array(), "delete" => array());

	public function __construct()
	{
	}

	/**
	 * @static
	 * @param int    $obj
	 * @param string $attribute
	 * @param string $value
	 * @param string $otype
	 * @param string $subtype
	 */
	public static function setAttribute($obj, $attribute, $value, $otype, $subtype)
	{
		if (!isset(self::$modifiedObjects["edit"][$obj]))
		{
			self::$modifiedObjects["edit"][$obj] = array(
				"attributes" => array(),
				"otype"      => $otype,
				"subtype"    => $subtype
			);
		}
		self::$modifiedObjects["edit"][$obj]["attributes"][$attribute] = $value;
	}

	/**
	 * @static
	 * @param int    $obj
	 * @param string $otype
	 * @param string $subtype
	 */
	public static function delete($obj, $otype, $subtype)
	{
		array_push(
			self::$modifiedObjects["delete"],
			array(
				"obj"     => $obj,
				"otype"   => $otype,
				"subtype" => $subtype
			)
		);
	}

	/**
	 * send information about changes to ObjectManager
	 *
	 * @throws Exception
	 */
	public static function send()
	{
		// send info about updated attributes
		foreach (self::$modifiedObjects["edit"] as $obj => $content)
		{
			if ($content["otype"] == "D" && in_array($content["subtype"], array("N", "C", "A", "S", "R", "E"))){
				$service = new ModifyObjects();
				$service->addProperty('TYPE', $content["otype"]);
				$service->addProperty('SUBTYPE', $content["subtype"]);

				$attributes = $content["attributes"];
				foreach($attributes as $attribute => $value)
				{
					$service->addProperty($attribute, $value);
				}

				$info = $service->UpdateObject($obj, $_SESSION[SESSION_USERID]);
				if ($info["status"] != 'OK')
				{
					throw new Exception($info["message"]);
				}
			}
		}

		// send info about deleted objects
		foreach (self::$modifiedObjects["delete"] as $content)
		{
			// only for devices now
			if ($content["otype"] == "D" && in_array($content["subtype"], array("N", "C", "A", "S", "R", "E"))){
				$service = new ModifyObjects();
				$service->addProperty('TYPE', $content["otype"]);
				$service->addProperty('SUBTYPE', $content["subtype"]);

				$info = $service->UpdateObject($content["obj"], $_SESSION[SESSION_USERID]);
				if ($info["status"] != 'OK')
				{
					throw new Exception($info["message"]);
				}
			}
		}
	}
}
