<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Monitor.php 26740 2012-09-07 15:08:53Z astarostin $
 * ------------------------------------------------------------------------------
 * This class represents logic for Monitor objects
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class Monitor extends Device
{
	public function __construct()
	{
		parent::__construct("monitor", "D", "V");
	}

	/**
	 * @throws InvalidArgumentException
	 * @param array $attributes
	 * @return int
	 */
	public function create(array $attributes)
	{
		if (isset($attributes['TCP_IP'])){
			$duplicateObj = $this->checkUniqueness(null, 'TCP_IP', $attributes['TCP_IP']);
			if ($this->checkUniqueness(null, 'TCP_IP', $attributes['TCP_IP'])){
				throw new InvalidArgumentException(sprintf(__(" IP device: obj = %d  has conflict with current device. Check TCP/IP Address settings."), $duplicateObj));
			}
		}
		$obj = parent::create($attributes);

		$uni = Node::getUNI();
		$nodeid = Node::getMasterNodeId();

		$devid = 'v' . $obj;

		DB::query("UPDATE _objs SET node_id = ?, node_ip = ? WHERE obj = ?;", array($nodeid, $uni, $obj));
		$this->setAttributes(
			$obj,
			array(
				"OBJID" => $obj,
				"DEVID" => $devid
			)
		);

		return $obj;
	}
	public function setAttributes($obj, array $attributes)
	{
		if (isset($attributes['TCP_IP'])){
			$duplicateObj = $this->checkUniqueness($obj, 'TCP_IP', $attributes['TCP_IP']);
			if ($this->checkUniqueness(null, 'TCP_IP', $attributes['TCP_IP'])){
				throw new InvalidArgumentException(sprintf(__(" IP device: obj = %d  has conflict with current device. Check TCP/IP Address settings."), $duplicateObj));
			}
		}
		parent::setAttributes($obj, $attributes);
	}
}
