<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: ModifyObjects.php 26709 2012-09-05 12:01:50Z stsibulskiy $
 * ------------------------------------------------------------------------------
 * Object editor
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

/**
 * Client for ObjectManagement service modifyObjects operation
 */
class ModifyObjects
{
	/**
	 * @var array
	 */
	private $params;

	/**
	 * @var array
	 */
	private $properties;

	/**
	 * @var array
	 */
	private $methods;

	/**
	 * @var SoapClient
	 */
	private $client;

	/**
	 * @var string
	 */
	private $url = "http://s_master/axis2/services/ObjectManagementService?wsdl";

	/**
	 * @return SoapFault|string
	 */
	private function callToServer()
	{
		$result = "";
		//DB::query("COMMIT;");
		//DB::query("SAVEPOINT my_savepoint;");
		try
		{
			$this->client = new SoapClient($this->url, array('trace' => 1));
			$this->client->__setCookie("PHPSESSID", session_id());

			$result = $this->client->modifyObjects($this->params);
		}
		catch (SoapFault $exception)
		{
			$result = $exception;
		}

		return $result;
	}

	/**
	 * @return string
	 */
	public function getLastRequest()
	{
		return $this->client->__getLastRequest();
	}

	/**
	 * @return string
	 */
	public function getLastResponse()
	{
		return $this->client->__getLastResponse();
	}

	/**
	 * @param string|null $url
	 */
	public function __construct($url = null)
	{
		if (isset($url))
		{
			$this->url = $url;
		}
		$this->clearProperties();
		$this->clearMethods();
	}

	public function clearProperties()
	{
		$this->properties = array();
		$this->properties["Property"] = array();
	}

	public function clearMethods()
	{
		$this->methods = array();
		$this->methods["Method"] = array();
	}

	/**
	 * @param string $name
	 * @param string $value
	 */
	public function addProperty($name, $value)
	{
		if (is_object($value) || is_array($value))
			$value = json_encode($value);

		$property = $this->properties["Property"];
		$i = count($property);
		if (!is_array($property))
			$i = 0;
		$this->properties["Property"][$i]["name"] = $name;
		$this->properties["Property"][$i]["value"] = $value;
		//$this->properties["Property"][$i]["displayname"] = $displayname;
	}

	/**
	 * @param string $name
	 * @param string $displayname
	 */
	public function addMethod($name, $displayname)
	{
		$method = $this->methods["Method"];
		$i = count($method);
		if (!is_array($method))
			$i = 0;
		$this->methods["Method"][$i]["name"] = $name;
		$this->methods["Method"][$i]["displayname"] = $displayname;
	}

	/**
	 * @param int $requestorId
	 * @return array
	 */
	public function CreateObject($requestorId)
	{
		$this->params = array(
			'requestorId' => $requestorId,
			'CreateObjectTask' => array(
			)
		);
		$this->params["CreateObjectTask"]["Properties"] = $this->properties;
		$this->params["CreateObjectTask"]["Methods"] = $this->methods;
		$result = $this->callToServer();
		$response = array();
		if (is_object($result))
		{
			$CreateObjectReceipt = $result->CreateObjectReceipt;
			$response["key"] = $CreateObjectReceipt->key;
			$response["objid"] = $CreateObjectReceipt->objid;
			$response["status"] = $CreateObjectReceipt->status;
			$response["errorCode"] = isset($CreateObjectReceipt->errorCode) ? $CreateObjectReceipt->errorCode : "";
			$response["message"] = isset($CreateObjectReceipt->message) ? $CreateObjectReceipt->message : "";
		} else {
			$response["status"] = 'FAILED';
			$response["message"] = $result;
		}

		return $response;
	}

	/**
	 * @param int $objid
	 * @param int $requestorId
	 * @return array
	 */
	public function UpdateObject($objid, $requestorId)
	{
		$this->params = array(
			'requestorId' => $requestorId,
			'UpdateObjectTask' => array(
				'objid' => $objid
			)
		);

		$this->params["UpdateObjectTask"]["Properties"] = $this->properties;
		$this->params["UpdateObjectTask"]["Methods"] = $this->methods;

		$result = $this->callToServer();

		$response = array();
		if (is_object($result))
		{
			$UpdateObjectReceipt = $result->UpdateObjectReceipt;

			//$response["key"] = $UpdateObjectReceipt->key;
			$response["objid"] = $UpdateObjectReceipt->objid;
			$response["status"] = $UpdateObjectReceipt->status;
			$response["errorCode"] = isset($UpdateObjectReceipt->errorCode) ? $UpdateObjectReceipt->errorCode : "";
			$response["message"] = isset($UpdateObjectReceipt->message) ? $UpdateObjectReceipt->message : "";
		} else {
			$response["status"] = 'FAILED';
			$response["message"] = $result;
		}

		return $response;
	}

	/**
	 * @param  int $objid
	 * @param  int $requestorId
	 * @return array
	 */
	public function DeleteObject($objid, $requestorId)
	{
		$this->params = array(
			'requestorId' => $requestorId,
			'DeleteObjectTask' => array(
				'objid' => $objid
			)
		);

		$result = $this->callToServer();

		$response = array();
		if (is_object($result))
		{
			$DeleteObjectReceipt = $result->DeleteObjectReceipt;

			$response["objid"] = $DeleteObjectReceipt->objid;
			$response["status"] = $DeleteObjectReceipt->status;
			$response["errorCode"] = isset($DeleteObjectReceipt->errorCode) ? $DeleteObjectReceipt->errorCode : "";
			$response["message"] = isset($DeleteObjectReceipt->message) ? $DeleteObjectReceipt->message : "";
		} else {
			$response["status"] = 'FAILED';
			$response["message"] = $result;
		}

		return $response;
	}

	/**
	 * @param int $objid
	 * @param int $requestorId
	 * @param string $method
	 * @return SoapFault|string
	 */
	public function invokeMethod($objid, $requestorId, $method)
	{
		$result = "";
		$this->params = array(
			'Method' => array(
				'name' => $method
			),
			'objid' => $objid
		);
		try
		{
			$this->client = new SoapClient($this->url, array('trace' => 1));
			$this->client->__setCookie("PHPSESSID", session_id());
			$this->client->invokeMethod($this->params);
		}
		catch (SoapFault $exception)
		{
			$result = $exception;
		}

		return $result;
	}
}
