<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Model.php 32021 2015-03-18 13:12:37Z astarostin $
 * ------------------------------------------------------------------------------
 * Class for working with Models
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class Model extends ObjectTemplate
{
	public function __construct()
	{
		$this->otype = "M";
		$this->subtype = "3";
		parent::__construct("model3d");
	}

	/**
	 * @param array $attributes
	 * @return int
	 */
	public function create(array $attributes)
	{
		if (isset($attributes["ASSOCIATE"]))
		{
			$ASSOCIATE = $attributes["ASSOCIATE"];
			$numberList = Template::parseList($ASSOCIATE);

			$layer = new Layer();
			$ASSOCIATE = "";

			end($numberList);
			$lastNumber = key($numberList);

			foreach ($numberList as $number => $value)
			{
				$layerId = $layer->create(array(
					"NAME" => $number,
					"NUMBER" => $number
				));

				$ASSOCIATE .= $layerId;

				if ($number != $lastNumber)
					$ASSOCIATE .= ",";
			}

			// store list of associated layer ids into ASSOCIATE attribute
			$attributes["ASSOCIATE"] = $ASSOCIATE;
		}

		return parent::create($attributes);
	}

	public function getObjects($obj, $otype = null, $subtype = null, $withAttributes = false, $withBlocks = false)
	{
		$list = array();

		$value = $this->getAttribute($obj, "ASSOCIATE");

		// return list of associated layers based on ids from ASSOCIATE attribute
		// list should be number devided by commas
		if (isset($value) && $value != "" && preg_match("/^\d+(,\s*\d+)*$/", $value))
		{
			// TODO: we must modify getting objects list for new type M
			$list = DB::select("
				SELECT
					_objs.obj, _objs.udid, _objs.name, _objs.description, _objs.location, _objs.otype, _objs.subtype, _objs.protected, 'M' AS permission, 'LVvApaeDMrCSPsm' AS credentials
					FROM _objs
					WHERE
						otype = ?
						AND subtype = ?
						AND obj in ($value)
						AND deleted = 0;",
				array("M", "L"));
		}

		if ($withAttributes)
		{
			foreach ($list as &$row)
			{
				// add list of linked attributes
				$attributes = $this->getAttributes($row["obj"]);
				$row["attributes"] = $attributes;
			}
		}

		if ($withBlocks)
		{
			foreach ($list as &$row)
			{
				// add list of linked blocks
				$blocks = $this->getBlocksInfo($row["obj"]);
				$row["blocks"] = $blocks;
			}
		}

		return $list;
	}
}
