<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Log.php 27611 2012-12-23 20:47:14Z astarostin $
 * ------------------------------------------------------------------------------
 * Singleton class for logger
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

abstract class Log
{
	private static $instance = NULL;

	/**
	 * is set to private to stop instantion

	 * @return \Log
	 */
	public function __construct()
	{}

	/**
	 * Clone is set to private to stop cloning
	 * @return void
	 */
    private function __clone()
    {}

	/**
	 * Return logger instance or create new instance
	 * @static
	 * @return \Log|null
	 */
    public static function getInstance()
    {
        if (!self::$instance)
        {
            self::$instance = new self();
        }
        return self::$instance;
    }

	abstract public static function debug($message, $userId = null);
	abstract public static function info($message, $userId = null);
	abstract public static function warning($message, $userId = null);
	abstract public static function error($message, $userId = null);
	abstract public static function getLog($userId, $fromTimeStamp = 0, $toTimeStamp = 'Infinity');
}
