<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Layer.php 21985 2011-02-23 18:18:15Z teetov $
 * ------------------------------------------------------------------------------
 * description
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */
 
class Location extends ObjectTemplate
{
	public function __construct()
	{
		$this->otype = "M";
		$this->subtype = "V";
		parent::__construct("location");
	}
	
	public function getListByRole($roleid) {
		if (!isset($roleid)){
			throw new InvalidArgumentException("roleid should be specified");
		}

		// Get all configurations
		$attr = DB::select("
			SELECT *
				FROM _obj_attr
				WHERE
					obj IN (
						SELECT _objs.obj
							FROM _objs, _obj_attr
							WHERE
								_objs.otype = 'M'
								AND _objs.subtype = 'V'
								AND _objs.deleted != 1
								AND _objs.obj = _obj_attr.obj
					)
				ORDER BY obj DESC",
			array()
		);
		
		$list = array();
		foreach ($attr as $row) {
			$list[$row['obj']]['obj'] = $row['obj'];
			$list[$row['obj']][$row['attr']] = $row['val'];
		}	

		// Filter all views by role id
		if($roleid != 31){
			foreach ($list as $row) {
				if ($row['LOC_ROLEID'] != $roleid) {
					unset($list[$row['obj']]);
				}
			}
		}		

		return array_values($list);
	}
}