<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id:$
 * ------------------------------------------------------------------------------
 * licensing
 * ------------------------------------------------------------------------------
 * @author Serg Tsybulsky, Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2015
 * ------------------------------------------------------------------------------
 */

class License {
	public function hasConnectToLicenseServer()
	{
		$fp = fsockopen("licenses.videonext.com", 80, $errno, $errstr, 30);
		if (!$fp)
		{
			throw new Exception("$errstr ($errno)");
		} else {
			fclose($fp);
		}

		return true;
	}

	public function getLicenseAttributesList()
	{
		$vainfo = va_admin_info();
		$attributes = array();

		$license_attributes = array(
			'ser'  => __('Serial Number'),
			'de'   => __('Expiration date'),
			'me'   => __('Maintenance expires'),
			'cam'  => __('Camera feeds'),
			'cna'  => __('Noarchive Cameras'),
			'aud'  => __('Audio feeds'),
		//); //used in full version
			'sen'  => __('Sensor Inputs'),
			'rel'  => __('Relays Inputs'),
			'vf'   => __('vMX: Video Feeds'),
			'vm'   => __('vMX: Monitors'),
			'edva' => __('Analytics: EDVA Channels'),
			'vca'  => __('Analytics: VCA'),
			'ov'   => __('Analytics: OV5 full channels'),
			'ovc'  => __('Analytics: OV Counting'),
			'ov5b' => __('Analytics: OV5 basic channels'),
			'ov5e' => __('Analytics: OV5 expanded channels'),
			'ov6' => __('Analytics: OV6'),
			'pgn'  => __('Analytics: Facial Detection MV'),
			'geo'  => __('Geo-Mapping interface'),
			'vac'  => __('vAC: number of Gateways'),
			'nod'  => __('Number of NODES'),
			'lun'  => __('Storage manager: number of LUNs'),
			'ver'  => __('Software version'),
			'av'   => __('Avatars'),
			'cls'  => __('Cloud storage'),
		);

		foreach ($license_attributes as $key => $label)
		{
			if (!isset($vainfo[$key]))
			{
				continue;
			}

			$attributes[$key] = $vainfo[$key];

			$attributes[$key]["label"] = $label;
			if (!isset($attributes[$key]["value"]))
			{
				$attributes[$key]["value"] = "0";
			}

			$tlimit = $attributes[$key]["limit"];
			if (!isset($tlimit) || $tlimit == '')
			{
				$attributes[$key]["limit"] = '1NaN';
			}
		}

		if (isset($attributes["me"]) && $attributes["me"]["limit"] === '1NaN')
		{
			$attributes["me"]["value"] = '1NaN';
		}

		if (isset($attributes["ver"]))
		{
			$info = Node::getInfo();
			$attributes["ver"]["value"] = $info['ver'];
			$licver = explode(".", $attributes["ver"]["limit"]);
			$curver = explode(".", $attributes["ver"]["value"]);
			if (isset($licver[0]) && isset($licver[1]) && isset($curver[0]) && isset($curver[0]) && $licver[0] == $curver[0] && $licver[1] == $curver[1])
			{
				$attributes["ver"]["overflow"] = false;
			} else {
				$attributes["ver"]["overflow"] = true;
			}
		}

		$dateFormat = Template::convertStrDateFormatToPHPDateFormat(Identity::getAttribute("NLS_LONG_DATE_FORMAT"));
		if (isset($attributes["de"]))
		{
			$attributes["de"]["limit"] = date($dateFormat, mktime(0, 0, 0, substr($attributes["de"]["limit"], 4, 2), substr($attributes["de"]["limit"], 6, 2), substr($attributes["de"]["limit"], 0, 4)));
			$attributes["de"]["value"] = date($dateFormat, mktime(0, 0, 0, substr($attributes["de"]["value"], 4, 2), substr($attributes["de"]["value"], 6, 2), substr($attributes["de"]["value"], 0, 4)));
		}
		if (isset($attributes["me"]))
		{
			$attributes["me"]["limit"] = date($dateFormat, mktime(0, 0, 0, substr($attributes["me"]["limit"], 4, 2), substr($attributes["me"]["limit"], 6, 2), substr($attributes["me"]["limit"], 0, 4)));
			$attributes["me"]["value"] = date($dateFormat, mktime(0, 0, 0, substr($attributes["me"]["value"], 4, 2), substr($attributes["me"]["value"], 6, 2), substr($attributes["me"]["value"], 0, 4)));
		}

		return $attributes;
	}

	/**
	 * @param string $serialNumber
	 *
	 * @throws Exception
	 */
	public function activateSerialNumber($serialNumber)
	{
		$hd_key_generator = "APL=" . $_SERVER["APL"] . " PERL5LIB=" . $_SERVER["PERL5LIB"] . " " . $_SERVER["APL"] . "/common/bin/gen_pc_id";
		$pc_id_path = $_SERVER["APL_VAR"] . "/license/pcid.bin";
		$get_license_host = "http://licenses.videonext.com";
		$upload_pcid_url = "$get_license_host/cirrus-activate/upload_pcid.php";

		try
		{
			Identity::setAttributes(array("SERIAL_NO" => $serialNumber));
			$output = array();
			exec(escapeshellcmd("$hd_key_generator $serialNumber"), $output, $return_var);

			$result = $this->file_post_contents($upload_pcid_url, $pc_id_path);

			if ($result["error"] !== "")
			{
				throw new Exception($result["error"]);
			} else {
				$license_serialNumber = $result["serialNumber"];
				$license_url = $get_license_host . $result["link"];

				$license_content = file_get_contents($license_url);
				$encoded_content = base64_encode($license_content);
				Identity::setAttributes(array("LICENSE_KEY" => $encoded_content));
				DB::query("UPDATE _objs SET stime=now() AT TIME ZONE 'UTC' WHERE otype='D' AND subtype='N' AND deleted=0");
			}
		}
		catch (Exception $e)
		{
			throw new Exception(sprintf(__("Cannot save serial number.") . "\n%s", $e->getMessage()));
		}
	}

	/**
	 * @param string $url
	 * @param string $filename
	 *
	 * @return array
	 */
	private function file_post_contents($url, $filename)
	{
		$url = parse_url($url);

		if (!isset($url['port']))
		{
			if ($url['scheme'] == 'http')
			{
				$url['port'] = 80;
			} else
			if ($url['scheme'] == 'https')
			{
				$url['port'] = 443;
			}
		}

		$fd = fopen($filename, 'rb');
		$file_content = fread($fd, filesize($filename));
		fclose($fd);

		$post = "-----------------------------25697491917780\r\n";
		$post .= "Content-Disposition: form-data; name=\"user_pcid\"; filename=\"" . basename($filename) . "\"\r\n";
		$post .= "Content-Type: application/octet-stream\r\n\r\n";
		$post .= $file_content . "\r\n";
		$post .= "-----------------------------25697491917780--";

		$head = "POST " . $url['path'] . " HTTP/1.1\r\n";
		$head .= "Host: " . $url['host'] . "\r\n";
		$head .= "User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; .NET CLR 1.0.3705; .NET CLR 1.1.4322; Media Center PC 4.0)\r\n";
		$head .= "Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8\r\n";
		$head .= "Accept-Language: ru,en-us;q=0.7,en;q=0.3\r\n";
		$head .= "Accept-Charset: windows-1251,utf-8;q=0.7,*;q=0.7\r\n";
		$head .= "Keep-Alive: 300\r\n";
		$head .= "Connection: keep-alive\r\n";
		$head .= "Connection: Close\r\n";
		$head .= "Referer: " . $url['host'] . "\r\n";
		$head .= "Cookie: PHPSESSID=" . $_COOKIE['PHPSESSID'] . "\r\n";
		$head .= "Content-Type: multipart/form-data; boundary=---------------------------25697491917780\r\n";
		$head .= "Content-Length: " . strlen($post) . "\r\n\r\n";
		$head .= $post;

		$result = array();

		$fp = fsockopen($url['host'], $url['port'], $errno, $errstr, 30);
		if (!$fp)
		{
			$result = array("error" => __("Cannot open socket"));
		} else {
			$response = "";

			fwrite($fp, $head);
			while (!feof($fp))
			{
				$response .= fgets($fp, 128);
			}
			fclose($fp);

			// clean from headers
			$response = strstr($response, "\r\n\r\n");
			$json = json_decode($response, true);
			$result = $json[0];
		}

		return $result;
	}

	/**
	 * @param string $serialNumber
	 *
	 * @throws Exception
	 */
	public function createPCID($serialNumber)
	{
		$hd_key_generator = "APL=" . $_SERVER["APL"] . " PERL5LIB=" . $_SERVER["PERL5LIB"] . " " . $_SERVER["APL"] . "/common/bin/gen_pc_id";

		try
		{
			Identity::setAttributes(array("SERIAL_NO" => $serialNumber));
			$output = array();
			exec(escapeshellcmd("$hd_key_generator $serialNumber"), $output, $return_var);
		}
		catch (Exception $e)
		{
			throw new Exception(__("Cannot save serial number."));
		}
	}
}
