<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Identity.php 26714 2012-09-05 14:52:33Z teetov $
 * ------------------------------------------------------------------------------
 * This class contains logic for System attributes (Identity)
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class Identity
{
	// Store the single instance of class
	/**
	 * @var ObjectTemplate $instance
	 */
	private static $instance;
	private static $obj = 53; // obj in _objs table of identity

	private function __construct()
	{
		return self::getInstance();
	}

	public static function getInstance()
	{
		if (!isset(self::$instance))
		{
			self::$instance = new ObjectTemplate("identity");
		}

		return self::$instance;
	}

	/**
	 * Don't allow cloning of the controller (this is a singleton)
	 */
	private function __clone()
	{
		trigger_error('Clone is not allowed', E_USER_ERROR);
	}

	public static function getObj()
	{
		return self::$obj;
	}

	public static function getAttribute($attribute)
	{
		return self::getInstance()->getAttribute(self::$obj, $attribute);
	}

	public static function setAttributes(array $attributes)
	{
		self::getInstance()->setAttributes(self::$obj, $attributes);
	}

	public static function getAttributes()
	{
		return self::getInstance()->getAttributes(self::$obj);
	}

	public static function getTemplateAttributes()
	{
		return self::getInstance()->getTemplateAttributes(self::getObj());
	}
}
