<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Gateway.php 20269 2010-09-27 14:22:54Z starostin $
 * ------------------------------------------------------------------------------
 * This class represents logic for external object Gateway
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */
 
class Gateway extends ExternalObject 
{
	public function __construct()
	{
		parent::__construct("gateway", "X", "G");
	}

	function getObjects($obj, $userid = null, $roleid = null, $withAttributes = false, $otype = null, $subtype = null, $filterAttribute = null, $filterMask = null)
	{
		$query = "
			SELECT o.obj, o.udid, o.name, o.description, o.otype, o.subtype, o.node_id
			FROM _objs o
			WHERE o.node_id = ?
			AND o.deleted = 0
			ORDER BY o.name;";

		$list = DB::select($query, array($obj));
		if ($withAttributes)
		{
			foreach ($list as &$row)
			{
				// add list of linked attributes
				$attributes = $this->getAttributes($row["obj"]);
				$row["attributes"] = $attributes;
			}
		}

		return $list;
	}
}