<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: FileLog.php 28462 2013-04-24 12:54:56Z astarostin $
 * ------------------------------------------------------------------------------
 * File implementation of logger interface
 * This class provides simple logging functionality
 *
 * @example usage
 * FileLog::info("info message");
 * FileLog::info("info message", 21);
 *
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class FileLog extends Log
{
	private static $pathLog = "/log/account_history.log";

	private static function write($logLevel, $message, $userId = null)
	{
		/*if (!isset($userId)) $userId = $_SESSION[SESSION_USERID];

		if (($f = fopen(APL_PATH . self::$pathLog, 'a+')) !== FALSE)
		{
			fwrite($f, date("Y/m/d H:i:s ") . " $logLevel: user[$userId] $message\n");
			fclose($f);
		}*/
	}

	public static function debug($message, $userId = null)
	{
		self::write("DEBUG", $message, $userId);
	}

	public static function info($message, $userId = null)
	{
		self::write("INFO", $message, $userId);
	}

	public static function warning($message, $userId = null)
	{
		self::write("WARNING", $message, $userId);
	}

	public static function error($message, $userId = null)
	{
		self::write("ERROR", $message, $userId);
	}

	public static function getLog($userId, $fromTimeStamp = 0, $toTimeStamp = 'Infinity')
	{
		$command = "egrep user\\\\[$userId\\\\] " . APL_VAR_PATH . self::$pathLog;

		$output = array();
		exec(escapeshellcmd($command), $output, $return_var);
		if ($return_var != 0)
		{
			$error = "Return value: $return_var";
			return array(
					'error' => $error
			);
		}

		return $output;
	}
}
