<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Factory.php 27730 2013-01-20 17:57:33Z astarostin $
 * ------------------------------------------------------------------------------
 * creates necessary object
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class Factory
{
	public function __construct()
	{}

	/**
	 * create and return object with type of specified obj
	 *
	 * @param int $obj
	 * @return Area|Audio|Avatar|Camera|Configuration|Door|External|Gateway|Layer|Location|Model|Monitor|Node|null|ObjectTemplate|Perimeter|Posture|Relay|Role|Schedule|SensorACSG|SensorSKM|Set|Timecard|User|View|Wall
	 */
	public static function getByObj($obj)
	{
		$typeObject = null;

		if (isset($obj) && $obj != "")
		{
			if ($obj != 53)
			{
				$object = new Obj();
				$type = $object->getType($obj);
			} else {
				$type = "identity";
			}

			$typeObject = self::getByType($type);
		}

		return $typeObject;
	}

	/**
	 * create and return object with specified type
	 *
	 * @param string $type
	 * @return Area|Audio|Avatar|Camera|Configuration|Door|External|Gateway|Layer|Location|Model|Monitor|Node|null|ObjectTemplate|Perimeter|Posture|Relay|Role|Schedule|SensorACSG|SensorSKM|Set|Timecard|User|View|Wall
	 */
	public static function getByType($type)
	{
		$typeObject = null;

		$typeToOtypeSubtype = Obj::getTypes(true);
		$typeToOtypeSubtype["identity"] = "";
		if (isset($typeToOtypeSubtype[$type]))
		{
			switch ($type)
			{
				case "configuration":
					$typeObject = new Configuration();
				break;
				case "view":
					$typeObject = new View();
				break;
				case "relay":
					$typeObject = new Relay();
				break;
				case "sensor_skm":
					$typeObject = new SensorSKM();
				break;
				case "audio":
					$typeObject = new Audio();
				break;
				case "monitor":
					$typeObject = new Monitor();
				break;
				case "model3d":
					$typeObject = new Model();
				break;
				case "modellayer":
					$typeObject = new Layer();
				break;
				case "location":
					$typeObject = new Location();
				break;
				case "wall":
					$typeObject = new Wall();
				break;
				case "external":
					$typeObject = new External();
				break;
				case "node":
					$typeObject = new Node();
				break;
				case "set":
					$typeObject = new Set();
				break;
				case "role":
					$typeObject = new Role();
				break;
				case "user":
					$typeObject = new User();
				break;
				case "gateway":
					$typeObject = new Gateway();
				break;
				case "sensor_acsg":
					$typeObject = new SensorACSG();
				break;
				case "door":
					$typeObject = new Door();
				break;
				case "perimeter":
					$typeObject = new Perimeter();
				break;
				case "area":
					$typeObject = new Area();
				break;
				case "camera":
					$typeObject = new Camera();
				break;
				case "posture":
					$typeObject = new Posture();
				break;
				case "schedule":
					$typeObject = new Schedule();
				break;
				case "timecard":
					$typeObject = new Timecard();
				break;
				case "avatar":
					$typeObject = new Avatar();
				break;
				case "identity":
					$typeObject = Identity::getInstance();
				break;
			}
		}

		return $typeObject;
	}
}
