<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: ExternalObject.php 33243 2015-11-01 23:59:59Z astarostin $
 * ------------------------------------------------------------------------------
 * This class represents logic for external objects
 *
 * Exception:
 * For objects otype = X attributes are not duplicated in the table _obj_attr, and are only used in the table _objs
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin, Serg Tsybulsky
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class ExternalObject extends Device
{
	/**
	 * @var ModifyObjects|null
	 */
	protected $service = null;

	public function __construct($type, $otype, $subtype)
	{
		$this->service = new ModifyObjects();
		$this->otype = $otype;
		$this->subtype = $subtype;

		parent::__construct($type, $this->otype, $this->subtype);
	}

	/**
	 * @throws Exception
	 * @param array $attributes
	 * @return int|null
	 */
	function create(array $attributes)
	{
		if (isset($attributes['MODELID']))
		{
			$templateAttributes = $this->getTemplate()->getDefaultAttributes(null, $attributes['MODELID']);
		} else {
			$templateAttributes = $this->getTemplate()->getDefaultAttributes();
		}
		foreach ($templateAttributes as $templateAttribute => $templateValue)
		{
			if (isset($attributes[$templateAttribute]))
			{
				$templateAttributes[$templateAttribute] = $attributes[$templateAttribute];
			}
		}

		$requestorId = $_SESSION[SESSION_USERID];

		$this->service->addProperty('TYPE', $this->otype);
		$this->service->addProperty('SUBTYPE', $this->subtype);

		foreach($templateAttributes as $attr => $value)
		{
			$this->service->addProperty($attr, $value);
		}

		if ($this->otype == 'X' && $this->subtype == 'G')
		{
			$this->service->addMethod('RESET', 'Reset');
			$this->service->addMethod('RESFRESH', 'Refresh');
		}

		$info = $this->service->CreateObject($requestorId);

		$result = null;

		if ($info["status"] == 'OK')
		{
			$result = $info["objid"];
		} else
			throw new Exception($info["message"]);
		return $result;
	}

	/**
	 * @param int    $obj
	 * @param mixed  $attribute
	 * @param string $value
	 * @return void
	 */
	public function setAttribute($obj, $attribute, $value)
	{
		$this->setAttributes($obj, array($attribute => $value));
	}

	/**
	 * @param int $obj
	 * @param array $attributes
	 * @throws Exception
	 */
	public function setAttributes($obj, array $attributes)
	{
		foreach ($attributes as $key => $value)
		{
			$value = trim($value);
			$this->service->addProperty($key, $value);
		}

		$info = $this->service->UpdateObject($obj, $_SESSION[SESSION_USERID]);
		if ($info["status"] != 'OK')
		{
			throw new Exception($info["message"]);
		}
	}

	/**
	 *
	 * @param  $obj
	 * @param  $attribute
	 * @return int|null
	 */
	public function getAttribute($obj, $attribute)
	{
		$value = null;

		if (in_array($attribute, array('NAME', 'DESC', 'UDID')))
		{
			$list = DB::select("select * from _objs where obj = ? and deleted = 0;", array($obj));

			if (count($list) > 0)
			{
				switch ($attribute)
				{
					case 'NAME':
						$value = $list[0]['name'];
					break;
					case 'DESC':
						$value = $list[0]['description'];
					break;
					case 'UDID':
						$value = $list[0]['udid'];
					break;
				}
			}
		} else {
			$value = parent::getAttribute($obj, $attribute);
		}

		return $value;
	}

	/**
	 * @param  $obj
	 * @return array
	 */
	public function getAttributes($obj)
	{
		$attributes = parent::getAttributes($obj);

		$list = DB::select("select * from _objs where obj = ? and deleted = 0;", array($obj));
		if (count($list) > 0)
		{
			$attributes['NAME'] = $list[0]['name'];
			$attributes['DESC'] = $list[0]['description'];
			$attributes['UDID'] = $list[0]['udid'];
		}

		return $attributes;
	}

	/**
	 * @param int $obj
	 * @return bool
	 * @throws Exception
	 */
	function delete($obj)
	{
		$info = $this->service->DeleteObject($obj, $_SESSION[SESSION_USERID]);
		if ($info["status"] != 'OK')
		{
			throw new Exception($info["message"]);
		}

		return true;
	}

	public function getObjects($obj, $otype = null, $subtype = null)
	{
		return array();
	}
}
