<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: External.php 28462 2013-04-24 12:54:56Z astarostin $
 * ------------------------------------------------------------------------------
 * This class represents logic for External object
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class External extends Device
{
	public function __construct()
	{
		parent::__construct("external", "D", "E");
	}

	function getObjects($obj, $userid = null, $roleid = null, $withAttributes = false, $otype = null, $subtype = null, $filterAttribute = null, $filterMask = null)
	{
/*		$userid = isset($userid) ? $userid : $_SESSION[SESSION_USERID];

		if (!isset($userid))
		{
			throw new InvalidArgumentException("Some parameters are missing.");
		}

		$user = new User();
		$allUserObjList = $user->getObjects($userid, $roleid, $withAttributes, $otype, $subtype);
*/
		$query = "
			SELECT o.obj, o.udid, o.name, description, location, node_id, otype, subtype
			FROM _objs o, _obj_attr a
			WHERE a.obj=o.obj
   			AND o.otype='D' AND (o.subtype='S' OR o.subtype='R')
   			AND a.attr='MODELID' AND a.val='MODBUS'
   			AND o.deleted = 0
   			AND o.node_id = ?;";
		$list = DB::select($query, array($obj));
		if ($withAttributes)
		{
			foreach ($list as &$row)
			{
				$attributes = $this->getAttributes($row["obj"]);
				$row["attributes"] = $attributes;
			}
		}
		return $list;
	}

	/**
	 * @param array $attributes
	 * @return int|null
	 */
	public function create(array $attributes)
	{
		$obj = null;

		if ($this->checkNoConflicts(null, $attributes)){
			$obj = parent::create($attributes);
			if (isset($attributes['NODE_ID'])){
				DB::query("UPDATE _objs SET node_id = ? WHERE obj = ?;", array($attributes['NODE_ID'], $obj));
			}
			$this->setAttribute($obj, 'DEVID', 'e'.$obj);
		}

		return $obj;
	}

	public function setAttributes($obj, array $attributes)
	{
		if ($this->checkNoConflicts($obj, $attributes)){
			parent::setAttributes($obj, $attributes);
		}
	}

	private function checkNoConflicts($obj=null, $attributes){
		//get node
		$node_id = '';
		$without_obj = '';

		if (isset($obj) && (int)$obj > 0) $without_obj = " and _objs.obj <> " . (int)$obj;
		if (isset($attributes['NODE_ID']) && (int)$attributes['NODE_ID'] > 0) $node_id = " and _objs.node_id = " . (int)$attributes['NODE_ID'];

		if (isset($attributes['IP'])){

			$query = "
				SELECT _objs.obj, _objs.description, a1.val
				FROM _objs, _obj_attr a1
				WHERE
					_objs.otype = 'D' AND _objs.subtype = ?
					AND _objs.obj = a1.obj AND a1.attr = 'IP'
					AND a1.val = ?
					$without_obj $node_id and _objs.deleted = 0;";
			$list = DB::select($query, array($this->subtype, $attributes['IP']));
			foreach($list as $item)
			{
				throw new InvalidArgumentException(sprintf(__(" IP device: [%d] %s has conflict with current device. Check IP address, device port settings."), $item['obj'], $item['description']));
			}
		}

		return true;
	}
}
