<?php defined('APL_PATH') or die('No direct script access.');
/**
 * $Id: EventPolicy.php 33025 2015-09-08 17:14:30Z astarostin $
 * ------------------------------------------------------------------------------
 * Event policy
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2015
 * ------------------------------------------------------------------------------
 */

class EventPolicy {
	private function getEventPolicyContentParametersNameDescriptionList()
	{
		$EventPolicyContentParametersNameDescription = array(
			"priority"  => __("Event priority. Integer value (references table eventpriority)"),
			"eventtype" => __("Type of event. Integer value (references table eventtype)"),
			"preevent"  => __("Number of seconds for determining utc_from"),
			"postevent" => __("Number of seconds for determining utc_to")
		);
		return $EventPolicyContentParametersNameDescription;
	}

	public function getEventSourceWorkflowList($id)
	{
		$list = DB::select(
			"SELECT workflow.workflow, workflow.name, workflow.description FROM workflow, eventsourceworkflow WHERE workflow.workflow = eventsourceworkflow.workflow AND eventsourceworkflow.eventsource = ? AND workflow.deleted = '0' ORDER BY workflow.name;",
			array($id)
		);

		return $list;
	}

	public function getWorkflowForEventPolicyContent($eventpolicy_id, $eventsource_id)
	{
		$list = DB::select(
			"SELECT workflow, infworkflow FROM eventpolicycontent WHERE eventpolicy = ? AND eventsource = ?",
			array($eventpolicy_id, $eventsource_id)
		);

		return $list;
	}

	public function getEventPriorityList()
	{
		$list = DB::select("SELECT eventpriority as id, name, description, colorname, colorcode FROM eventpriority ORDER BY eventpriority;");

		return $list;
	}

	public function getEventLifeSpanList()
	{
		$list = DB::select("SELECT eventlifespan as id, name, description FROM eventlifespan ORDER BY eventlifespan;");

		return $list;
	}

	public function getEventType()
	{
		$list = DB::select("SELECT eventtype as id, name, description FROM eventtype ORDER BY eventtype;");

		return $list;
	}

	private function getEventPolicyStorageList($eventpolicy)
	{
		$list = DB::select(
			"SELECT eventpolicystorage.eventpolicy, eventpolicystorage.eventpriority as id, eventpolicystorage.preserverhours, eventpriority.name, eventpriority.description FROM eventpolicystorage, eventpriority WHERE eventpolicystorage.eventpolicy = ? AND eventpolicystorage.eventpriority = eventpriority.eventpriority ORDER BY id;",
			array($eventpolicy)
		);

		return $list;
	}

	public function getEventPolicyStorageEventLifeSpan($eventpolicy)
	{
		$eventpolicystoragelist = $this->getEventPolicyStorageList($eventpolicy);
		if (count($eventpolicystoragelist) > 0)
		{
			return $eventpolicystoragelist;
		} else {
			$eventPriorityList = $this->getEventPriorityList();
			foreach($eventPriorityList as &$item)
			{
				$item["preserverhours"] = "";
			}
			return $eventPriorityList;
		}
	}

	public function getEventSourceParametersList($eventpolicy_id)
	{
		$EventPolicyContentParametersNameDescription = $this->getEventPolicyContentParametersNameDescriptionList();

		$list = DB::select("SELECT eventsource, name, description FROM eventsource ORDER BY name;");

		$eventsourceparameterslist = array();
		foreach ($list as $listitem)
		{
			$element = array();
			$element["eventsource"] = $listitem["eventsource"];
			$element["name"] = $listitem["name"];
			$element["description"] = $listitem["description"];
			$element["parameters"] = array();

			$parameters = $this->getEventPolicyContentParametersList($eventpolicy_id, $listitem["eventsource"]);

			foreach ($EventPolicyContentParametersNameDescription as $key => $value)
			{
				if (isset($parameters[$key]))
					$element["parameters"][$key] = $parameters[$key];
				else
					$element["parameters"][$key] = "";
			}
			$eventsourceparameterslist[] = $element;
		}

		return $eventsourceparameterslist;
	}

	private function getEventPolicyContentParametersList($eventpolicy_id, $eventsource_id)
	{
		$list = DB::select(
			"SELECT parameters FROM eventpolicycontent WHERE eventpolicy = ? AND eventsource = ?;",
			array($eventpolicy_id, $eventsource_id)
		);

		if (is_array($list) && isset($list[0]["parameters"]))
		{
			if ($list[0]["parameters"] == "")
				return "";
		} else {
			return "";
		}

		$parameters = explode("|", $list[0]["parameters"]);
		$parameters_list = array();
		for ($i = 0; $i < count($parameters); $i++)
		{
			$tmp = explode("=", $parameters[$i]);
			$parameters_list[$tmp[0]] = $tmp[1];
		}
		return $parameters_list;
	}

	public function getEventPolicyList()
	{
		$list= DB::select("SELECT eventpolicy, name, description, protected FROM eventpolicy ORDER BY name;");

		return $list;
	}

	/**
	 * @param int $eventpolicy
	 *
	 * @return array
	 */
	public function getEventPolicy($eventpolicy)
	{
		$list = DB::select(
			"SELECT eventpolicy, name, description, protected FROM eventpolicy WHERE eventpolicy = ?;",
			array($eventpolicy)
		);

		return $list;
	}

	/**
	 * @param string $name
	 * @param string $description
	 * @param array $eventsource_workflow_parameters
	 * @param array $eventpolicystorage
	 *
	 * @throws Exception
	 */
	public function addEventPolicy($name, $description, $eventsource_workflow_parameters, $eventpolicystorage)
	{
		if(!is_array($eventpolicystorage))
		{
			// i18n: do not translate word "eventpolicystorage"
			throw new InvalidArgumentException(__("eventpolicystorage must be array"));
		}

		$name = trim($name);
		if ($name == "")
		{
			throw new InvalidArgumentException(__("Eventpolicy name must be not empty."));
		}

		$list = DB::select(
			"SELECT eventpolicy FROM eventpolicy WHERE name = ?;",
			array($name)
		);
		if (!empty($list))
		{
			throw new InvalidArgumentException(__("Event Policy name must be unique"));
		}

		try
		{
			DB::query(
				"INSERT INTO eventpolicy (eventpolicy, name, description, protected) VALUES ((SELECT greatest(max(eventpolicy) + 1,100) FROM eventpolicy), ?, ?, '0');",
				array($name, $description)
			);

			if (!is_array($eventsource_workflow_parameters))
			{
				throw new InvalidArgumentException(__("Parameters must be array"));
			}

			foreach ($eventsource_workflow_parameters as $eventsource_workflow_parameter)
			{
				$eventsource = $eventsource_workflow_parameter["eventsource"];
				$workflow = $eventsource_workflow_parameter["workflow"];
				$infworkflow = $eventsource_workflow_parameter["infworkflow"];
				$workflow_parameters = $eventsource_workflow_parameter["parameters"];
				$parameters = "";
				foreach ($workflow_parameters as $key => $value)
				{
					if (trim($value) != "")
						$parameters .= trim($key) . '=' . trim($value) . '|';
				}
				if (strlen($parameters) > 0)
					if ($parameters[strlen($parameters) - 1] == '|')
						$parameters = substr($parameters, 0, -1);

				DB::query(
					"INSERT INTO eventpolicycontent (eventpolicy, eventsource, workflow, infworkflow, parameters) VALUES ((SELECT max(eventpolicy) FROM eventpolicy), ?, ?, ?, ?);",
					array($eventsource, $workflow, $infworkflow, $parameters)
				);
			}

			foreach($eventpolicystorage as $element)
			{
				DB::query(
					"INSERT INTO eventpolicystorage (eventpolicy, eventpriority, preserverhours) VALUES ((SELECT max(eventpolicy) FROM eventpolicy), ?, ?);",
					array($element["eventpriority"], $element["preserverhours"])
				);
			}
		} catch (Exception $e){
			throw new Exception(sprintf(__("Cannot add event policy.\n") . "%s", $e));
		}

		$this->savePolicyToAvatar();
	}

	/**
	 * @param int $eventpolicy
	 * @param string $name
	 * @param string $description
	 * @param array $eventsource_workflow_parameters
	 * @param array $eventpolicystorage
	 *
	 * @throws Exception
	 */
	public function editEventPolicy($eventpolicy, $name, $description, $eventsource_workflow_parameters, $eventpolicystorage)
	{
		if(!is_array($eventpolicystorage))
		{
			throw new InvalidArgumentException(__("eventpolicystorage must be array"));
		}

		$name = trim($name);
		if ($name == "")
		{
			throw new InvalidArgumentException(__("Eventpolicy name must be not empty."));
		}

		$list = DB::select(
			"SELECT eventpolicy FROM eventpolicy WHERE name = ? AND eventpolicy != ?;",
			array($name, $eventpolicy)
		);
		if (!empty($list))
		{
			throw new InvalidArgumentException(__("Event Policy name must be unique"));
		}

		try
		{
			DB::query(
				"UPDATE eventpolicy SET name = ?, description = ? WHERE eventpolicy = ? AND protected = '0';",
				array($name, $description, $eventpolicy)
			);

			if (!is_array($eventsource_workflow_parameters))
			{
				throw new InvalidArgumentException(__("Parameters must be array"));
			}

			foreach ($eventsource_workflow_parameters as $eventsource_workflow_parameter)
			{
				$eventsource = $eventsource_workflow_parameter["eventsource"];
				$workflow = $eventsource_workflow_parameter["workflow"];
				$infworkflow = $eventsource_workflow_parameter["infworkflow"];
				$workflow_parameters = $eventsource_workflow_parameter["parameters"];
				$parameters = "";
				foreach ($workflow_parameters as $key => $value)
				{
					if (trim($value) != "")
						$parameters .= trim($key) . '=' . trim($value) . '|';
				}
				if (strlen($parameters) > 0)
					if ($parameters[strlen($parameters) - 1] == '|')
						$parameters = substr($parameters, 0, -1);

				DB::query(
					"UPDATE eventpolicycontent SET workflow = ?, infworkflow = ?, parameters = ? WHERE eventpolicy = ? AND eventsource = ? AND (SELECT protected FROM eventpolicy WHERE eventpolicy = ?) = '0';",
					array($workflow, $infworkflow, $parameters, $eventpolicy, $eventsource, $eventpolicy)
				);
			}

			foreach($eventpolicystorage as $element)
			{
				DB::query(
					"UPDATE eventpolicystorage SET preserverhours = ? WHERE eventpriority = ? AND eventpolicy = ? AND (SELECT protected FROM eventpolicy WHERE eventpolicy = ?) = '0';",
					array($element["preserverhours"], $element["eventpriority"], $eventpolicy, $eventpolicy)
				);
			}
		} catch (Exception $e){
			throw new Exception(sprintf(__("Cannot add event policy.\n") . "%s", $e));
		}

		$this->savePolicyToAvatar();
	}

	/**
	 * @param int $id
	 */
	public function deleteEventPolicy($id)
	{
		$list = DB::select(
			"SELECT name FROM eventpolicy WHERE eventpolicy = ? AND protected = '0';",
			array($id)
		);

		$name = "";
		if (count($list) > 0)
		{
			$name = $list[0]["name"];
		}

		$list = DB::select(
			"SELECT * FROM _objs, _obj_attr WHERE _objs.obj = _obj_attr.obj AND _objs.deleted <> 1 AND _obj_attr.attr = 'EVENT_POLICY' AND _obj_attr.val = ?;",
			array($id)
		);

		if (count($list) > 0)
		{
			$obj_arr = array();
			foreach($list as $row){
				$obj_arr[] = "[".$row['obj']."] ".$row['name'];
			}

			throw new InvalidArgumentException(sprintf(__('Policy %s was not deleted because it is used by next devices: %s '),$name, implode(", ", $obj_arr)));
		}

		DB::query(
			"DELETE FROM eventpolicystorage WHERE eventpolicy = ? AND (SELECT protected FROM eventpolicy WHERE eventpolicy = ?) = '0';",
			array($id, $id)
		);
		DB::query(
			"DELETE FROM eventpolicycontent WHERE eventpolicy = ? AND (SELECT protected FROM eventpolicy WHERE eventpolicy = ?) = '0';",
			array($id, $id)
		);
		DB::query(
			"DELETE FROM eventpolicy WHERE eventpolicy = ? AND protected = '0';",
			array($id)
		);

		$this->savePolicyToAvatar();
	}

	/**
	 * get summarize info about event policies
	 *
	 * @return array
	 */
	private function policyInfo()
	{
		$eventPolicyList = array();

		$list = DB::select("SELECT * FROM eventpolicy;");
		foreach ($list as $row)
		{
			$eventpolicy = $row["eventpolicy"];
			$name = $row["name"];
			$description = $row["description"];

			$eventPolicyList[$eventpolicy] = array(
				"name" => $name,
				"description" => $description,
				"eventsource" => array()
			);
		}

		$list = DB::select("SELECT * FROM eventpolicycontent;");
		foreach ($list as $row)
		{
			$eventpolicy = $row["eventpolicy"];
			$eventsource = $row["eventsource"];
			$workflow = $row["workflow"];
			$infworkflow = $row["infworkflow"];

			$parameters = array();
			// ex: priority=2|eventtype=0|preevent=5|postevent=15
			$parameterList = explode("|", $row["parameters"]);
			foreach ($parameterList as $parameter)
			{
				list($key, $value) = explode("=", $parameter);
				$parameters[$key] = intval($value);
			}

			$eventPolicyList[$eventpolicy]["eventsource"][$eventsource] = array(
				"workflow" => intval($workflow),
				"infworkflow" => intval($infworkflow),
				"parameters" => $parameters
			);
		}

		return $eventPolicyList;
	}

	/**
	 * save summarize info about event policies to avatar
	 *
	 * @param int|null $obj avatar id
	 *
	 * @throws AuthException
	 */
	public function savePolicyToAvatar($obj = null)
	{
		$policyInfo = $this->policyInfo();

		$avatar = new Avatar();

		if (isset($obj))
		{
			$avatar->setAttributes($obj, array("EVENT_POLICY_INFO" => json_encode($policyInfo)));
		} else {
			$node = new Node();
			$list = $node->getAllObjects("V", "*");

			foreach ($list as $row)
			{
				$avatar->setAttributes($row["obj"], array("EVENT_POLICY_INFO" => json_encode($policyInfo)));
			}
		}
	}
}
