<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Emailer.php 26714 2012-09-05 14:52:33Z teetov $
 * ------------------------------------------------------------------------------
 * Implementation for sending email
 *
 * ------------------------------------------------------------------------------
 * @author Serg Tsybulsky
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2013
 * ------------------------------------------------------------------------------
 */

class Emailer
{
	private $snapshotViewerURL = "";   # TBD: hostname
	private $retainSnaphots = '2 days';
	private $smtp_cfg= array();
	private $event_cfg= array();
	private $ip= '';
	public $policys = array();

	public function __construct() {
		$this->ip = Node::getUriByUNI(Node::getUNI());
		$this->snapshotViewerURL = "http://" . $this->ip . "/sdi/evu/eventlist.php?snapshotid=";   # TBD: hostname
		$this->getEmailerCfg();
	}

	/**
	 * Get configuration of parameters for send emails
	 * set parameters in smtp_cfg array
	 *
	 * @param void
	 * @return array
	 */
	public function getEmailerCfg()
	{
		$configXML = @file_get_contents("http://s_master/api/cgi-bin/dynadata.cgi?return=datablock&typeid=Emailer");
		$parser = xml_parser_create();
		xml_parser_set_option($parser, XML_OPTION_CASE_FOLDING, 0);
		xml_parser_set_option($parser, XML_OPTION_SKIP_WHITE, 1);
		xml_parse_into_struct($parser, $configXML, $values, $tags);
		xml_parser_free($parser);
		unset($tags);
		unset($configXML);

		$result = array();
		$id = 0;
		foreach ($values as $el)
		{
			if ($el['tag'] == 'POLICY' && $el['type'] == 'open' && $el['level'] == 5)
			{
				$id = $el['attributes']['LEVEL'];
				$result[$id]['LEVEL'] = $id;
				$result[$id]['CODE'] = $el['attributes']['CODE'];
			}
			elseif ($el['tag'] == 'POLICY' && $el['type'] == 'close' && $el['level'] == 5)
			{
				$id = 0;
			}
			elseif ($el['level'] == 6 && isset($el['attributes']))
			{
				$result[$id][$el['tag']] = urldecode($el['attributes']['VALUE']);
			}
			elseif ($el['tag'] == 'CONFIG' && $el['type'] == 'complete' && $el['level'] == 5)
			{
				$this->smtp_cfg['SERVER'] = urldecode($el['attributes']['SERVER']);
				$this->smtp_cfg['EMAIL'] = urldecode($el['attributes']['EMAIL']);
				$this->smtp_cfg['USER'] = urldecode($el['attributes']['USER']);
				$this->smtp_cfg['PASSWORD'] = urldecode($el['attributes']['PASSWORD']);
				$this->smtp_cfg['STATUS'] = urldecode($el['attributes']['STATUS']);
				$this->event_cfg['EVENTS_DETAILS_ENABLE'] = urldecode($el['attributes']['EVENTS_DETAILS_ENABLE']);
				$this->event_cfg['EVENTS_DETAILS_AMOUNT'] = urldecode($el['attributes']['EVENTS_DETAILS_AMOUNT']);
				if (isset($el['attributes']['PORT'])) $this->smtp_cfg['PORT'] = urldecode($el['attributes']['PORT']);
				else $this->smtp_cfg['PORT'] = 25;
				if (isset($el['attributes']['SECURE'])) $this->smtp_cfg['SECURE'] = urldecode($el['attributes']['SECURE']);
			}
		}
		$this->policys = $result;
		return $this->smtp_cfg;
	}

	/**
	 * Sends email
	 * get configuration parameters from smtp_cfg array
	 *
	 * @param string $to
	 * @param string $subject
	 * @param string $body text body of letter, with html tags
	 * @param string $altBody text body of letter, (!)without html tags
	 * @param array $embeddedImages images to embed in format EmbeddedName=>Link
	 * @return array
	 */
	public function sendEmail($to, $subject, $body, $altBody='', $embeddedImages = array()) {
		$mail = new PHPMailer(true);
		try {
			// set host parameters
			$mail->isSMTP();                                      // Set mailer to use SMTP
			$mail->SMTPAuth = true;                               // Enable SMTP authentication
			$mail->Host = $this->smtp_cfg['SERVER'];
			$mail->Username = $this->smtp_cfg['USER'];
			$mail->Password = $this->smtp_cfg['PASSWORD'];
			if(isset($this->smtp_cfg['SECURE']) && $this->smtp_cfg['SECURE']!='')
				$mail->SMTPSecure = $this->smtp_cfg['SECURE'];
			if(isset($this->smtp_cfg['PORT']) && $this->smtp_cfg['PORT']!='')
				$mail->Port = $this->smtp_cfg['PORT'];
			else $mail->Port = 25;

			$mail->From = $this->smtp_cfg['EMAIL'];
			$mail->FromName = __('System Mailer');

			$mail->AddAddress($to);

			// set mail parameters
			$mail->WordWrap = 50;                               // Set word wrap to 50 characters
			$mail->isHTML(true);                                // Set email format to HTML

			// Add a recipient
			$mail->Subject = $subject;

			// add images to email
			foreach ($embeddedImages as $key => $value){
				$webURL = "http://s_master".$value;
				$tmpURL = "/tmp/".$key.".jpg";
				file_put_contents($tmpURL, file_get_contents($webURL));
				$mail->addEmbeddedImage($tmpURL, $key, $key.".jpg", "base64", "image/jpeg");
			}

			$mail->Body    = $body;

			if ($altBody !=''){
				$mail->AltBody = $altBody;
			}

			//TODO insert log if sent, if isn't sent
			$result = $mail->send();
			if(!$result) {
				error_log('Email could not be sent. Mailer Error: ' . $mail->ErrorInfo);
				//audit sent email from to subject
			}else{
				//audit sent email from to subject
			}

			// delete temporary images by mask
			foreach (glob("/tmp/emailerImgEvent*.jpg") as $filename) {
				if(unlink($filename) == false){
					$last_error = error_get_last();
					error_log('Emailer could not delete temporary file: ' . $filename . '. Error: type = ' . $last_error['type'] . ', message = ' . $last_error['message']);
				}
			}
		} catch (phpmailerException $e) {
			error_log('Email could not be sent. Mailer Error: ' . $e->errorMessage());
		} catch (Exception $e) {
			error_log('Email could not be sent. Error: ' . $e->errorMessage());
		}
		return $result;
	}

	/**
	 * Delete old snapshots
	 *
	 * @param void
	 * @return array
	 */
	public function recycleSnapshots() {
		try	{
			DB::query(
				"DELETE FROM event_emailer_snapshot WHERE ts_created < now() at time zone 'UTC' - INTERVAL '?';",
				array($this->retainSnaphots));
		} catch (Exception $e) {
			error_log('Failed to deleted: ' . $e->getMessage());
			$result = false;
		}
	}

	/**
	 * Prepare email with events
	 *
	 * @param string $name
	 * @param string $descr
	 * @param string $email
	 * @param int $snapshot
	 * @param int $count
	 * @param int $roleid
	 * @param string $rolename string
	 * @param array $events_details events details
	 * @return array
	 */
	public function sendEmail2User($name, $descr, $email, $snapshot, $count, $roleid, $rolename, $events_details = array()) {
		if ($roleid){
			$subj = "Subject: Automated event[s] notification: $snapshot. Role: $rolename\n\r";
		}else{
			$subj = "Subject: Automated event[s] notification: $snapshot.\n\r";
		}

		$events_attachments = array();
		$eventDetailsHTML = "";
		if($this->event_cfg['EVENTS_DETAILS_ENABLE'] == "YES"){
			$eventDetailsHTML.= "<div>";
			$eventDetailsHTML.= "<strong>".__("Last events")."</strong>:<br />";
			$eventDetailsHTML.= "<ul>";
			for($i = 0; $i < count($events_details); $i++){
				$imageName = "emailerImgEvent".$events_details[$i]["eventid"];
				$imageTimestamp = $events_details[$i]["utc_when"];
				$imageLink = "/storage/snapshot?objid=" . $events_details[$i]["objid"] . "&ts=" .$imageTimestamp. "&downscale&vae_snapshot=alarm";
				$events_attachments[$imageName] = $imageLink;

				$eventDetailsHTML.= "<li>";
				$eventDetailsHTML.= __("Event")." : <strong>".$events_details[$i]["eventid"]."</strong><br />";
				$eventDetailsHTML.= __("Device")." : ".$events_details[$i]["dev_name"]."<br />";
				if(!empty($events_details[$i]["dev_location"])){
					$eventDetailsHTML.= __("Location")." : ".$events_details[$i]["dev_location"]."<br />";
				}
				$eventDetailsHTML.= __("When (UTC)")." : ".$events_details[$i]["utc_when_string"]."<br />";
				$eventDetailsHTML.= '<img src="cid:'.$imageName.'" alt="'.$events_details[$i]["eventid"].'" /><br />';

				if($events_details[$i]["note"] != ""){
					$eventDetailsHTML.= __("Note")." : ".$events_details[$i]["note"]."<br />";
				}

				if($events_details[$i]["message"] != ""){
					$eventDetailsHTML.= __("Message")." : ".$events_details[$i]["message"]."<br />";
				}

				$eventDetailsHTML.= "<br />";
				$eventDetailsHTML.= "</li>";
			}
			$eventDetailsHTML.= "</ul>";
			$eventDetailsHTML.= "</div>";
		}

		$snapshotLink = $this->snapshotViewerURL . $snapshot;
		if ($roleid){
			$snapshotLink = $snapshotLink . "&roleid=" . $roleid;
		}
		$msg = "";
		$msg .=
		($descr? "<p>$descr,<br><br></p>\n\r" : "") .
		"<p>You have $count events waiting for your review here: <a href='$snapshotLink'>$snapshotLink</a></p>\n\r        \n\r        " .
		"<p>System will retain snapshot for " . $this->retainSnaphots . " before recycling it.</p>\n\r        ".
		$eventDetailsHTML;

		$this->sendEmail($email, $subj, $msg, '', $events_attachments);
	}

	/**
	 * Prepare data for Event Emails
	 *
	 * @param void
	 * @return array
	 */
	public function sendEventEmails() {
		try	{
			DB::query(
				"DELETE FROM event_emailer_tag ".
				"WHERE userid NOT IN ".
					"(SELECT ou.obj FROM ".
						"(select o.obj, o.otype, o.subtype, o.name, o.description, o.deleted, o.protected, oa1.val as email, oa2.val as email_int ".
						"from _objs o  ".
						"left join _obj_attr oa1 on o.obj=oa1.obj and oa1.attr = 'EMAIL' ".
						"left join _obj_attr oa2 on o.obj=oa2.obj and oa2.attr = 'EMAIL_INTERVAL' ".
						"where o.otype = 'U') ou ".
					"WHERE ou.otype='U' AND trim(ou.email_int) <> '' AND cast(ou.email_int as int)>=0 AND ou.email LIKE '%@%' AND ou.email LIKE '%.%');",
				array());
		} catch (Exception $e) {
			error_log('Failed to delete: ' . $e->getMessage());
			$result = false;
		}

		try	{
			DB::query(
				"INSERT INTO event_emailer_tag (userid,last_eventid,last_send) ".
				"SELECT ou.obj,0,0 FROM ".
						"(select o.obj, o.otype, o.subtype, o.name, o.description, o.deleted, o.protected, oa1.val as email, oa2.val as email_int ".
						"from _objs o  ".
						"left join _obj_attr oa1 on o.obj=oa1.obj and oa1.attr = 'EMAIL' ".
						"left join _obj_attr oa2 on o.obj=oa2.obj and oa2.attr = 'EMAIL_INTERVAL' ".
						"where o.otype = 'U' and deleted=0) ou ".
					"WHERE trim(ou.email_int) <> '' AND cast(ou.email_int as int)>=0 ".
						"AND ou.email LIKE '%@%' AND ou.email LIKE '%.%' " .
						"AND ou.obj NOT IN (SELECT userid FROM event_emailer_tag);",
				array());
		} catch (Exception $e) {
			error_log('Failed to add: ' . $e->getMessage());
			$result = false;
		}

		$exec_time = time() - 30;
		$list = DB::select(
			"SELECT userid,ou.name,ou.description,ou.email,ou.email_int,last_eventid,last_send ".
			"FROM event_emailer_tag, ".
					"(select o.obj, o.otype, o.subtype, o.name, o.description, o.deleted, o.protected, oa1.val as email, oa2.val as email_int ".
					"from _objs o  ".
					"left join _obj_attr oa1 on o.obj=oa1.obj and oa1.attr = 'EMAIL' ".
					"left join _obj_attr oa2 on o.obj=oa2.obj and oa2.attr = 'EMAIL_INTERVAL' ".
					"where o.otype = 'U') ou ".
			"WHERE userid=ou.obj AND last_send+60*cast(ou.email_int as int)<?;",
			array($exec_time));

		foreach ($list as $recp_row){
			// determine SNAPSHOT ID
			$sid_arr = DB::select("SELECT nextval_seq_event_emailer_snapshot() as nextval");
			if (isset($sid_arr[0]['nextval'])){
				$snapshotID = $sid_arr[0]['nextval'];
			}

			// assemble snapshot in one shot :)
			DB::query(
				"INSERT INTO event_emailer_snapshot ".
					"SELECT ?,?,e1.eventid ".
					"FROM event e1 ".
					"INNER JOIN eventwitness w1 ON w1.eventid = e1.eventid ".
					"WHERE e1.eventid > ? AND e1.eventtype != 0 ".
					"AND w1.objid IN ( ". "select obj from getObjects(?, null, null, null) o where o.credentials like '%I%')",
				array($snapshotID,$recp_row['userid'],$recp_row['last_eventid'],$recp_row['userid']));

			$events_details = array();
			// if event details enabled
			if($this->event_cfg['EVENTS_DETAILS_ENABLE'] == "YES"){
				// get event id's
				$events_details = DB::select(
					"SELECT e2.eventid as eventid,e2.message as message,e2.note as note, extract(epoch from e2.utc_when at time zone 'UTC') as utc_when,e2.utc_when as utc_when_string,e2.objid as objid,o.name as dev_name,o.location as dev_location ".
						"FROM event e2 ".
						"INNER JOIN _objs o ON o.obj=e2.objid ".
						"WHERE e2.eventid IN (".
							"SELECT e1.eventid ".
								"FROM event e1 ".
								"INNER JOIN eventwitness w1 ON w1.eventid = e1.eventid ".
								"WHERE e1.eventid > ? AND e1.eventtype != 0 ".
								"AND extract(epoch from e1.utc_when at time zone 'UTC') < ? ".
								"AND w1.objid IN (select obj from getObjects(?, null, null, null) o where o.credentials like '%I%')".
							") ORDER BY e2.eventid DESC LIMIT ". $this->event_cfg['EVENTS_DETAILS_AMOUNT'],
					array($recp_row['last_eventid'],$exec_time,$recp_row['userid']));
			}

			// count events in snapshot - it may be empty and it is no reason to send email
			$cnt_snap_arr = DB::select(
				"SELECT count(*) as cnt, max(eventid) as maxeventid FROM (SELECT DISTINCT eventid FROM event_emailer_snapshot WHERE snapshotid=?) ees",
				array($snapshotID));
			$cnt_snap = $cnt_snap_arr[0]['cnt'];
			$max_eventid = $cnt_snap_arr[0]['maxeventid'];

			// added role
			$role_list = DB::select("SELECT * from  getRoles(?)",array($recp_row['userid']));
			foreach ($role_list as $role_row){
				$cnt_snap_cred = DB::select(
					"SELECT count (t.eventid) as cnt FROM " .
						"(SELECT distinct d.eventid FROM (select distinct w.eventid, w.objid as obj from event_emailer_snapshot ees, eventwitness w where w.eventid = ees.eventid and ees.snapshotid=?) d, " .
						"getObjects(?, ?, null, null) o " .
						"WHERE   " .
						"d.obj = o.obj AND " .
						"o.credentials like '%v%' AND " .
						"o.credentials like '%I%' " .
						") t; ",
					array($snapshotID, $recp_row["userid"], $role_row["obj"]));
				$cnt_snap_cred = $cnt_snap_cred[0]['cnt'];

				// determine if email has to be sent and send it
				if($cnt_snap && $cnt_snap_cred && (($this->event_cfg['EVENTS_DETAILS_ENABLE'] == "YES" && count($events_details) > 0) || $this->event_cfg['EVENTS_DETAILS_ENABLE'] == "NO")){
					$this->sendEmail2User($recp_row['name'], $recp_row['description'], $recp_row['email'], $snapshotID, $cnt_snap,$role_row['obj'], $role_row['name'], $events_details);
					// advance tag for this user
					DB::query("UPDATE event_emailer_tag SET last_eventid=?, last_send=? WHERE userid=?",
						array($max_eventid,$exec_time,$recp_row['userid']));
				}
			}
		}
	}

	/**
	 * Prepare data for Emailer and call sending emails
	 *
	 * @param void
	 * @param loglevel - log type (INFO, WARN, ERROR, FATAL)
	 * @param per	- gen info from this time
	 * @param toEmail - receiver
	 * @return array
	 */
	public function sendReportEmails($loglevel, $per, $toEmail) {
		if (!isset($loglevel) || $loglevel == '')
			$loglevel = "INFO";


		if (!isset($toEmail) || $toEmail == ''){
			return false;
		}
		$isReported = 0;
		$tmpstmp = date('Y-m-d H:i:s', $per);
		$curtmp = date('Y-m-d H:i:s');


		$subj = "List of events level=$loglevel from $tmpstmp to $curtmp\n\n";
		$repstr = '';
		if ($loglevel != 'EVENT')
		{
			$list = DB::select(
				"SELECT " .
					"a.date as adate, l.name as lname, c.digest as digest, " .
					"a.parameters as parameters, o.udid as udid, u.name as uname " .
				"FROM audit a " .
				"INNER JOIN auditcategory c ON c.category = a.category " .
				"INNER JOIN auditlevel l ON l.level = a.level " .
				"LEFT JOIN _objs o ON o.obj = a.objid AND COALESCE(c.parent,0) != 16 " .
				"LEFT JOIN _objs u ON u.obj = a.userid ".

				"WHERE a.date > '". $tmpstmp ."'::timestamp and l.name = '".$loglevel."' ".
				"ORDER BY 1",
			array());

			foreach ($list as $audit_row){
				$username = '[System]';
				if ($audit_row['uname']) {
					$username = '[' .$audit_row['uname']. ']';
				}
				$repstr .= sprintf("%.22s	%s	%s ", $audit_row['adate'], $username, formatAuditMessage($audit_row['digest'], $audit_row['parameters']));
				if ($audit_row['udid'] || $audit_row['uname']) {
					$repstr .= ' [';
					if ($audit_row['udid']) $repstr .= 'device=' . $audit_row['udid'] . ' ';
					if ($audit_row['uname']) $repstr .= 'user=' . $audit_row['uname'] ;
					$repstr .= ']';
				}
				$repstr .= "\n<br/>";
			}
		}
		else
		{
			$repstr = $alert;
		}
		if ($repstr)
		{
			$addressList = explode(";", $toEmail);
			foreach ($addressList as $addr)
			{
				$header = 'EVENT REPORT from the server: '. $this->ip . "\n\n<br/><br/>$repstr";
				$this->sendEmail($addr, $subj, $header, $altBody='');
			}
			$repstr = '';
			$alert = '';
		}
		return array();
	}

}

/*
// Returns formatted audit message (insert parameters into message digest)
*/
function formatAuditMessage($digest, $parameters) {
    $msg = "";
	if ($digest) {
		$msg = $digest;

		if (isset($parameters)) {
			try{
				$parametersJson = json_decode($parameters);
				if (is_array($parametersJson) && count($parametersJson)>=0){
					$msgParamsRef = $parametersJson[0];
					if (is_array($msgParamsRef) && count($msgParamsRef)>=0){
						for ($i=0; $i<count($msgParamsRef); $i++) {
							$msg = str_replace("%".($i+1), $msgParamsRef[$i], $msg);
						}
					}
				}
			} catch (Exception $e) {
				echo ('Failed to parse json: '. $e->getMessage() . "\n");
			}
		}
	}
	return $msg;
}

