<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: DroneMobile.php 28744 2013-05-24 18:08:44Z jpooton $
 * ------------------------------------------------------------------------------
 * client for http://live.dronemobile.com/login/default.aspx
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class DroneMobile
{
	private $avatarid;

	public function __construct($avatarId)
	{
		$this->avatarid = $avatarId;
	}

	public function sendCommand($attribute, $value)
	{
		$attributeToAction = array(
			"POWER" => array(
				"on" => "Aux 1",
				"off" => "Lock"
			),
			"CHANNEL" => array(
				"on" => "Aux 1",
				"off" => "UnLock"
			),
			"ENGINE" => array(
				"on" => "Remote start On/Off",
				"off" => ""
			)
		);

		$command = $attributeToAction[$attribute][$value];

		// check if command is implemented
		if (!isset($command) || empty($command))
		{
			throw new Exception("command not supported");
		}

		$VIEWSTATE = "";
		$EVENTVALIDATION = "";

		$VIEWSTATE_regexp = '/__VIEWSTATE" value="([^"]*)"/';
		$EVENTVALIDATION_regexp = '/__EVENTVALIDATION" value="([^"]*)"/';

		$avatar = new Avatar();
		$avatarAttributes = $avatar->getAttributes($this->avatarid);

		$user = $avatarAttributes["REMOTE_CONTROL_USER"];
		$password = $avatarAttributes["REMOTE_CONTROL_PASSWORD"];

		$cookieFile = '/tmp/cookie_' . mt_rand() . '.txt';

		$curlHandle = curl_init();
		$options = array(
			CURLOPT_AUTOREFERER => true,
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_SSL_VERIFYPEER => false,
			CURLOPT_HEADER => true,
			CURLINFO_HEADER_OUT => true,
			CURLOPT_USERAGENT=> "Mozilla/5.0 (Ubuntu; X11; Linux x86_64; rv:9.0.1) Gecko/20100101 Firefox/9.0.1",
			CURLOPT_COOKIEJAR => $cookieFile
		);
		curl_setopt_array($curlHandle, $options);

		/**
		 * STEP 1
		 * get login page
		 */
		$url = "http://live.dronemobile.com/login/default.aspx";
		$options = array(
			CURLOPT_POST => false,
			CURLOPT_URL => $url,
		);
		curl_setopt_array($curlHandle, $options);

		if (($result = curl_exec($curlHandle)) === FALSE)
		{
			return false;
		}
		// print_r(curl_getinfo($curlHandle, CURLINFO_HEADER_OUT));

		$VIEWSTATE = $this->getValue($result, $VIEWSTATE_regexp);
		$EVENTVALIDATION = $this->getValue($result, $EVENTVALIDATION_regexp);

		/**
		 * STEP 2
		 * login
		 */
		$body = array(
			"__EVENTTARGET" => "",
			"__EVENTARGUMENT" => "",
			"__EVENTVALIDATION" => $EVENTVALIDATION,
			"__VIEWSTATE" => $VIEWSTATE,
			'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$txtUserId' => $user,
			'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$txtPassword' => $password,
			'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$lnkBtnlogin.x' => 81,
			'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$lnkBtnlogin.y' => 22
		);
		$url = "http://live.dronemobile.com/login/default.aspx";
		$options = array(
			CURLOPT_URL => $url,
			CURLOPT_POST => true,
			CURLOPT_POSTFIELDS => $body,
			CURLOPT_COOKIEFILE => $cookieFile
		);
		curl_setopt_array($curlHandle, $options);

		if (($result = curl_exec($curlHandle)) === FALSE)
		{
			return false;
		}
		//print_r(curl_getinfo($curlHandle, CURLINFO_HEADER_OUT));

		/**
		 * STEP 3
		 * get page with controls
		 */
		$url = "http://live.dronemobile.com/login/DroneMobile/EndUser/Control.aspx";
		$options = array(
			CURLOPT_URL => $url,
			CURLOPT_POST => false,
			CURLOPT_COOKIEFILE => $cookieFile
		);
		curl_setopt_array($curlHandle, $options);

		if (($result = curl_exec($curlHandle)) === FALSE)
		{
			return false;
		}

		$VIEWSTATE = $this->getValue($result, $VIEWSTATE_regexp);
		$EVENTVALIDATION = $this->getValue($result, $EVENTVALIDATION_regexp);

		//print_r(curl_getinfo($curlHandle, CURLINFO_HEADER_OUT));

		/**
		 * STEP 4
		 * send command
		 */
		$action = array(
			"Remote start On/Off" => 'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$imgBtnRemoteStartOnOff',
			"Lock" => 'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$imgBtnDoorLock',
			"UnLock" => 'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$imgBtnDoorUnLock',
			"Siren" => 'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$imgBtnSiren',
			"Trunk" => 'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$imgBtnTrunk',
			"Aux 1" => 'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$imgBtnAux1',
			"Aux 2" => 'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$imgBtnAux2'
		);

		$url = "http://live.dronemobile.com/login/DroneMobile/EndUser/control.aspx";
		$body = array(
			"__EVENTTARGET" => "",
			"__EVENTARGUMENT" => "",
			"__LASTFOCUS" => "",
			"__VIEWSTATE" => $VIEWSTATE,
			"__EVENTVALIDATION" => $EVENTVALIDATION,
			'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$ddlVehicle' => "4369",
			'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$ddlVehicleExpStatus' => "0",
			'ctl00$ctl00$ContentPlaceHolder1$ContentPlaceHolder1$hdnServicePlan' => "Basic"
		);

		$body[$action[$command] . ".x"] = 18;
		$body[$action[$command] . ".y"] = 18;

		$body_str = "";
		foreach ($body as $key => $value)
		{
			$body_str .= "$key=" . urlencode($value) . "&";
		}
		$options = array(
			CURLOPT_REFERER => "http://live.dronemobile.com/login/DroneMobile/EndUser/Control.aspx",
			CURLOPT_URL => $url,
			CURLOPT_POSTFIELDS => $body_str,
			CURLOPT_POST => true,
			CURLOPT_COOKIEFILE => $cookieFile
		);
		curl_setopt_array($curlHandle, $options);

		if (($result = curl_exec($curlHandle)) === FALSE)
		{
			return false;
		}
		// print_r(curl_getinfo($curlHandle, CURLINFO_HEADER_OUT));

		curl_close($curlHandle);

		unlink($cookieFile);

		return true;
	}

	private function getValue($string, $regexp)
	{
		$result = null;

		$matches = array();
		if (preg_match($regexp, $string, $matches))
		{
			$result = $matches[1];
		}

		return $result;
	}
}