<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Device.php 26714 2012-09-05 14:52:33Z teetov $
 * ------------------------------------------------------------------------------
 * This class represents logic for Devices
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class Device extends ObjectTemplate
{
	public function __construct($type, $otype, $subtype)
	{
		$this->otype = $otype;
		$this->subtype = $subtype;
		parent::__construct($type);
	}

	/**
	 * set device attributes
	 *
	 * @param  int $obj
	 * @param  array $attributes
	 */
	public function setAttributes($obj, array $attributes)
	{
		// update stime for associated schedule
		if (isset($attributes["SCHEDULEID"]))
		{
			$oldSCHEDULEID = $this->getAttribute($obj, 'SCHEDULEID');
			// update stime if SCHEDULEID is changed
			if ($oldSCHEDULEID != $attributes["SCHEDULEID"])
			{
				if (isset($oldSCHEDULEID) && $oldSCHEDULEID != "")
				{
					$this->updateSTime($oldSCHEDULEID);
				}
				if ($attributes["SCHEDULEID"] != "")
				{
					$this->updateSTime($attributes["SCHEDULEID"]);
				}
			}
		}

		parent::setAttributes($obj, $attributes);
	}
}
