<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: DBLog.php 27611 2012-12-23 20:47:14Z astarostin $
 * ------------------------------------------------------------------------------
 * DB implementation of logger interface
 * This class provides simple logging functionality
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions, Inc, 2010
 * ------------------------------------------------------------------------------
 */

class DBLog extends Log
{
	private static $logLevels = array(
		"DEBUG" => 1,
		"INFO" => 2,
		"WARNING" => 3,
		"ERROR" => 4,
	);

	public function __construct()
	{}

	private static function write($logLevelIdentifier, $message, $userId = null)
	{
		$page = "";
		$category = 1;
		$logLevel = isset(self::$logLevels[$logLevelIdentifier]) ? self::$logLevels[$logLevelIdentifier] : 2;

		try
		{
			DB::query(
				"INSERT INTO app_log (category, loglevel, programm, message) VALUES (?, ?, ?, ?);",
				array($category, $logLevel, $page, $message)
			);
		}
		catch (Exception $e)
		{}
	}

	public static function debug($message, $userId = null)
	{
		self::write("DEBUG", $message, $userId);
	}

	public static function info($message, $userId = null)
	{
		self::write("INFO", $message, $userId);
	}

	public static function warning($message, $userId = null)
	{
		self::write("WARNING", $message, $userId);
	}

	public static function error($message, $userId = null)
	{
		self::write("ERROR", $message, $userId);
	}

	public static function getLog($userId, $fromTimeStamp = 0, $toTimeStamp = 'Infinity')
	{}
}
