<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: CredentialContainer.php 26714 2012-09-05 14:52:33Z teetov $
 * ------------------------------------------------------------------------------
 * This class represents logic for credential container
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

class CredentialContainer extends ObjectTemplate
{
	public function __construct($type)
	{
		parent::__construct($type);
	}

	/**
	 * check for link existens
	 *
	 * @param  int $parentobj
	 * @param  int $childobj
	 * @return bool
	 */
	public function isLinkExists($parentobj, $childobj)
	{
		$isLinkExists = false;

		$list = DB::select(
			"SELECT * FROM _links WHERE obj_res = ? AND obj_cons = ?;",
			array($childobj, $parentobj)
		);
		if (count($list) > 0)
		{
			$isLinkExists = true;
		}

		return $isLinkExists;
	}

	/**
	 * add childobject to container
	 *
	 * @param  int $parentobj
	 * @param  int $childobj
	 * @param null $permission
	 * @throws InvalidArgumentException
	 * @return bool
	 */
	public function add($parentobj, $childobj, $permission = null)
	{
		if (!isset($parentobj) || !isset($childobj))
		{
			throw new InvalidArgumentException("Some parameters are missing.");
		}

		$result = true;

		// check if link already exists
		if (!$this->isLinkExists($parentobj, $childobj))
		{
			$result = false;

			$number = DB::query(
				"INSERT INTO _links(obj_res, obj_cons, permission, protected) VALUES (?, ?, ?, ?);",
				array($childobj, $parentobj, $permission, 0)
			);

			if ($number > 0)
			{
				$result = true;
			}
		}

		return $result;
	}

	/**
	 * add several objects to container
	 * if one ore more items from $childList are rejected for adding, function throw exception
	 *
	 * @param  int   $parentobj
	 * @param  array $childList
	 * @param  bool  $isProtectedCheck
	 * @throws InvalidArgumentException
	 * @return void
	 */
	public function addList($parentobj, array $childList = array(), $isProtectedCheck = false)
	{
		$object = new Obj();

		$parentType = $object->getType($parentobj);
		$isProtected = $object->isProtected($parentobj);
		$parentName = $object->getName($parentobj);
		$rejectedList = array();

		if ($parentType == 'role' || $parentType == "set")
		{
			foreach ($childList as $childobj)
			{
				$obj_child = Factory::getByObj($childobj);
				$isChildProtected = $obj_child->isProtected($childobj);
				$childName = $obj_child->getName($childobj);
				$childType = $obj_child->getType($childobj);
				if ($parentType == 'role' && $isProtected && $isChildProtected
					||
					$parentType == 'set' && $isProtected)
				{
					$rejectedList[$childobj] = $childType . " " . '"' . $childName . '"';
				} else {
					$this->add($parentobj, $childobj);
				}
			}
			if (count($rejectedList) > 0)
			{
				$rejectedListString = implode(", ", $rejectedList);
				throw new InvalidArgumentException(sprintf(__("Could not add %s to %s %s."), $rejectedListString, $parentType, '"' . $parentName . '"'));
			}
		} else {
			if ($isProtectedCheck)
				$isProtected = $object->isProtected($parentobj);

			if (!$isProtectedCheck || $isProtectedCheck && !$isProtected)
			{
				foreach ($childList as $childobj)
				{
					$this->add($parentobj, $childobj);
				}
			}
		}
	}

	/**
	 * remove childobject from container
	 *
	 * @throws InvalidArgumentException
	 * @param  int $parentobj
	 * @param  int $childobj
	 * @return bool
	 */
	public function remove($parentobj, $childobj)
	{
		if (!isset($parentobj) || !isset($childobj))
		{
			throw new InvalidArgumentException("Some parameters are missing.");
		}

		$result = false;

		$number = DB::query(
			"DELETE FROM _links
				USING _objs
				WHERE
					_objs.obj = _links.obj_cons
					AND _objs.otype = ?
					AND _objs.subtype = ?
					AND _links.obj_res = ?
					AND _links.obj_cons = ?
					AND _links.protected = ?;",
			array($this->otype, $this->subtype, $childobj, $parentobj, 0)
		);
		if ($number > 0)
		{
			$result = true;
		}
		return $result;
	}

	/**
	 * remove several objects from container
	 * if one ore more items from $childList are rejected for deleting, function throw exception
	 *
	 * @param  int   $parentobj
	 * @param  array $childList
	 * @param  bool  $isProtectedCheck
	 * @throws InvalidArgumentException
	 * @return void
	 */
	public function removeList($parentobj, array $childList = array(), $isProtectedCheck = false)
	{
		$object = new Obj();

		$parentType = $object->getType($parentobj);
		$isProtected = $object->isProtected($parentobj);
		$parentName = $object->getName($parentobj);
		$rejectedList = array();

		if ($parentType == 'role' || $parentType == "set")
		{
			foreach ($childList as $childobj)
			{
				$obj_child = Factory::getByObj($childobj);
				$isChildProtected = $obj_child->isProtected($childobj);
				$childName = $obj_child->getName($childobj);
				$childType = $obj_child->getType($childobj);
				if ($parentType == 'role' && $isProtected && $isChildProtected
					||
					$parentType == 'set' && $isProtected)
				{
					$rejectedList[$childobj] = $childType . " " . '"' . $childName . '"';
				} else {
					$this->remove($parentobj, $childobj);
				}
			}
			if (count($rejectedList) > 0)
			{
				$rejectedListString = implode(", ", $rejectedList);
				throw new InvalidArgumentException(sprintf(__("Could not remove %s from %s %s."), $rejectedListString, $parentType, '"' . $parentName . '"'));
			}
		} else {
			if ($isProtectedCheck)
				$isProtected = $object->isProtected($parentobj);

			if (!$isProtectedCheck || $isProtectedCheck && !$isProtected)
			{
				foreach ($childList as $childobj)
				{
					$this->remove($parentobj, $childobj);
				}
			}
		}
	}

	/**
	 * check if link is protected
	 *
	 * @param int $resobj
	 * @param int $consobj
	 * @return bool
	 */
	public function isLinkProtected($resobj, $consobj)
	{
		$isProtected = false;

		$list = DB::select("SELECT protected FROM _links WHERE obj_res = ? AND obj_cons = ? AND protected = 1;", array($resobj, $consobj));
		if (count($list) > 0)
		{
			if ($list[0]["protected"] == "1")
			{
				$isProtected = true;
			}
		}

		return $isProtected;
	}
}
