<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: Certificate.php 27611 2012-12-23 20:47:14Z astarostin $
 * ------------------------------------------------------------------------------
 * This class contains logic for Node
 * ------------------------------------------------------------------------------
 * @author Serge Tsybulsky
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

class Certificate
{
	public static function isPresent()
	{
		$SERTIFICATE_PATH = APL_VAR_PATH . '/conf/certificate/cert.csr';
		return is_file($SERTIFICATE_PATH);
	}
	public static function isRequestPresent()
	{
		$CERT_REQUEST_PATH = APL_VAR_PATH . '/conf/certificate/cert_req.csr';
		return is_file($CERT_REQUEST_PATH);
	}

	public static function getStatus()
	{
		return array(
			'requestpresent' => Certificate::isRequestPresent(),
			'certificatepresent' => Certificate::isPresent(),
		);
	}

	public static function createRequest(array $attributes)
	{
		$PRIVATEKEY_PATH = APL_VAR_PATH . '/conf/.keys/privatekey.pem';
		$CERT_REQUEST_PATH = APL_VAR_PATH . '/conf/certificate/cert_req.csr';
		$OPENSSL_PATH = APL_VAR_PATH . '/conf/certificate/openssl.conf';

		if (isset($attributes)){
			$file = fopen($OPENSSL_PATH,"w");
			if(!$file){
				throw new Exception(__("Can't write to Certificate request file"));
			}else{
				fwrite ( $file, "[req]\n");
				fwrite ( $file, "default_bits=2048\n");
				fwrite ( $file, "default_md=sha1\n");
				fwrite ( $file, "prompt=no\n");
				fwrite ( $file, "distinguished_name=root_ca_distinguished_name\n");
				fwrite ( $file, "\n");
				fwrite ( $file, "[root_ca_distinguished_name]\n");
				if (isset($attributes['domain']))
					fwrite ( $file, "commonName = " . $attributes['domain'] . "\n");
				if (isset($attributes['state_or_province']))
					fwrite ( $file, "stateOrProvinceName = " . $attributes['state_or_province'] . "\n");
				if (isset($attributes['country']))
					fwrite ( $file, "countryName = " . $attributes['country'] . "\n");
				if (isset($attributes['email']))
					fwrite ( $file, "emailAddress = " . $attributes['email'] . "\n");
				if (isset($attributes['organization']))
					fwrite ( $file, "organizationName = " . $attributes['organization'] . "\n");
				if (isset($attributes['localityName']))
					fwrite ( $file, "localityName = " . $attributes['localityName'] . "\n");
				if (isset($attributes['organizationalUnitName']))
					fwrite ( $file, "organizationalUnitName = " . $attributes['organizationalUnitName'] . "\n");
			}
			fclose ($file);

			exec(escapeshellcmd("rm " . $CERT_REQUEST_PATH));
			$command = "openssl req -new -nodes -key " . $PRIVATEKEY_PATH . " -out " . $CERT_REQUEST_PATH . " -config " . $OPENSSL_PATH;
			$output = array();
			exec(escapeshellcmd($command), $output, $return_var);

			$request = array();
			$rfile = file($CERT_REQUEST_PATH);
			foreach ($rfile as $line)
			{
				$request[] = $line;
			}
			return $request;
		}
		throw new InvalidArgumentException(__("Attributes missing"));
	}

	public static function getRequestInfo()
	{
		$CERT_REQUEST_PATH = APL_VAR_PATH . '/conf/certificate/cert_req.csr';

		$exists = false;
		$request = array();
		if (is_file($CERT_REQUEST_PATH)){
			$exists = true;
			$rfile = file($CERT_REQUEST_PATH);
			foreach ($rfile as $line)
			{
				$request[] = $line;
			}
		}
		return array(
			'exists' => $exists,
			'info' => $request,
		);
	}


	public static function validate($cert_path = '')
	{
		$CERTIFICATE_PATH = APL_VAR_PATH . '/conf/certificate/cert.csr';

		if ($cert_path !== ''){
			$CERTIFICATE_PATH = $cert_path;
		}

		$command = "openssl verify -CAfile " . APL_PATH . "/imp/etc/pki/vCrypt/ca-bundle.pem -verbose " . $CERTIFICATE_PATH;
		$output = array();
		exec(escapeshellcmd($command), $output, $return_var);
		if ($output[0] && strpos($output[0], ": OK"))
			return true;
		else
			return false;
	}

	public static function install($content = '')
	{
		$CERTIFICATE_PATH = APL_VAR_PATH . '/conf/certificate/cert.csr';
		$CERTIFICATE_TMP_PATH = APL_VAR_PATH . '/conf/certificate/cert_tmp.csr';

		if ($content !== ''){
			$file = fopen($CERTIFICATE_TMP_PATH,"w");
			if(!$file){
				throw new Exception(__("Can't write to file:") . $CERTIFICATE_TMP_PATH);
			}else{
				fwrite ( $file, $content);
			}
			fclose ($file);
			if (Certificate::validate($CERTIFICATE_TMP_PATH)){
				$command = "mv " . $CERTIFICATE_TMP_PATH . " " . $CERTIFICATE_PATH;
				$output = array();
				exec(escapeshellcmd($command), $output, $return_var);
				return true;
			}else{
				throw new Exception(__("Can't install certificate."));
			}
		}else
			throw new InvalidArgumentException(__("Can't install certificate."));
	}

	public static function signmedia($mediain_file, $mediaout_file = '')
	{
		$CERTIFICATE_PATH = APL_VAR_PATH . '/conf/certificate/cert.csr';
		$PRIVATEKEY_PATH = APL_VAR_PATH . '/conf/.keys/privatekey.pem';
		if ($mediaout_file == '') $mediaout_file = $mediain_file . ".out";

		if (Certificate::isPresent() && Certificate::validate()){
			$command = "vCrypt -private:" . $PRIVATEKEY_PATH . "-cert:" . $CERTIFICATE_PATH . " - -" . $mediain_file . " " . $mediaout_file;
			$output = array();
			exec(escapeshellcmd($command), $output, $return_var);
			if ($return_var == 0){
				return true;
			}
		}
		return false;
	}

	public static function getCertificateInfo()
	{
		$CERTIFICATE_PATH = APL_VAR_PATH . '/conf/certificate/cert.csr';
		$valid = false;
		$output = array();
		if (Certificate::isPresent() && Certificate::validate()){
			$valid = true;
			$command = "openssl x509 -noout -subject -issuer -serial -email -dates -fingerprint -in " . $CERTIFICATE_PATH;
			exec(escapeshellcmd($command), $output, $return_var);
			if ($return_var != 0){
				$output = array();
			}
		}
		return array(
			'valid' => $valid,
			'info' => $output,
		);
	}

}

