<?php defined('APL_PATH') or die('No direct script access.');
/**
 * @version $Id: AutoLoad.php 31578 2014-12-08 14:07:22Z astarostin $
 * ------------------------------------------------------------------------------
 * This class represent logic for auto loading class files
 * ------------------------------------------------------------------------------
 * @author Andrey Starostin
 * @QA
 * @copyright videoNEXT Network Solutions LLC 2006
 * ------------------------------------------------------------------------------
 */

class AutoLoad
{
	/**
	 * class
	 * @var array
	 */
	private static $classMap = array(
		"Stomp"                => "3rdParty/Stomp/Stomp.php",
		"vcalendar"            => "3rdParty/iCalendar/iCalcreator.class.php",
		"iCalUtilityFunctions" => "3rdParty/iCalendar/iCalcreator.class.php",
		"PHPMailer"            => "3rdParty/PHPMailer/class.phpmailer.php",
		"SMTP"				   => "3rdParty/PHPMailer/class.smtp.php",
		"adLDAP"               => "3rdParty/adLDAP/adLDAP.php"
	);

	public function __construct()
	{

	}

	public static function auto_load($className)
	{
		if(isset(self::$classMap[$className]))
		{
			include_once(CLASS_PATH . DIRECTORY_SEPARATOR . self::$classMap[$className]);
		} else {
			// include class file relying on include_path
			if (strpos($className, '\\') === false) // class without namespace
			{
				$classFile = CLASS_PATH . DIRECTORY_SEPARATOR . $className . ".php";
				if (is_file($classFile))
				{
					include($classFile);
				}
			} else {
				// class name with namespace in PHP 5.3
				list($namespace1, $namespace2, $className) = preg_split("/\\\\/", $className);
				if ($namespace1 == "VAE")
				{
					$vaeList = Node::getVAEList();
					$classFile = $vaeList[$namespace2] . DIRECTORY_SEPARATOR . "www" . DIRECTORY_SEPARATOR . "lib"  . DIRECTORY_SEPARATOR . "php"  . DIRECTORY_SEPARATOR . $className . ".php";
					if (is_file($classFile))
					{
						include($classFile);
					}
				}
			}

			return class_exists($className, false) || interface_exists($className, false);
		}

		return true;
	}
}
